<?php
// הוספת עמודות חסרות לטבלת order_additions
require_once 'includes/config.php';
$pdo = getDB();

echo "<h2>הוספת עמודות חסרות לטבלת order_additions</h2>";

$columns = [
    'customer_charge' => "DECIMAL(10,2) DEFAULT 0 COMMENT 'גביה מלקוח בשקלים' AFTER amount_ils",
    'profit' => "DECIMAL(10,2) DEFAULT 0 COMMENT 'רווח על התוספת' AFTER customer_charge"
];

foreach ($columns as $column => $definition) {
    try {
        // בדיקה אם העמודה קיימת
        $check = $pdo->query("SHOW COLUMNS FROM order_additions LIKE '{$column}'");
        if ($check->rowCount() == 0) {
            $pdo->exec("ALTER TABLE order_additions ADD COLUMN {$column} {$definition}");
            echo "<p style='color:green;'>✅ עמודה {$column} נוספה בהצלחה</p>";
        } else {
            echo "<p style='color:blue;'>ℹ️ עמודה {$column} כבר קיימת</p>";
        }
    } catch (Exception $e) {
        echo "<p style='color:red;'>❌ שגיאה בהוספת {$column}: " . $e->getMessage() . "</p>";
    }
}

// הוספת אינדקס על created_at אם לא קיים
try {
    $pdo->exec("ALTER TABLE order_additions ADD INDEX idx_created_at (created_at)");
    echo "<p style='color:green;'>✅ אינדקס idx_created_at נוסף</p>";
} catch (Exception $e) {
    echo "<p style='color:blue;'>ℹ️ אינדקס כבר קיים</p>";
}

echo "<h3>מבנה הטבלה הנוכחי:</h3>";
$result = $pdo->query("DESCRIBE order_additions");
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Default</th></tr>";
while ($row = $result->fetch()) {
    echo "<tr><td>{$row['Field']}</td><td>{$row['Type']}</td><td>{$row['Null']}</td><td>{$row['Default']}</td></tr>";
}
echo "</table>";

echo "<p><strong>✅ סיום!</strong></p>";
?>
