<?php
require_once 'includes/config.php';
$pdo = getDB();

echo "<h2>🔧 תיקון כל העמודות החסרות</h2>";

$queries = [
    // orders table - ALL missing columns
    "ALTER TABLE orders ADD COLUMN board_basis VARCHAR(100) NULL",
    "ALTER TABLE orders ADD COLUMN num_passengers INT DEFAULT 1",
    "ALTER TABLE orders ADD COLUMN currency VARCHAR(10) DEFAULT 'ILS'",
    "ALTER TABLE orders ADD COLUMN payment_method VARCHAR(50) DEFAULT 'credit_card'",
    "ALTER TABLE orders ADD COLUMN receipt_number VARCHAR(50) NULL",
    "ALTER TABLE orders ADD COLUMN receipt_url TEXT NULL",
    "ALTER TABLE orders ADD COLUMN receipt_date DATETIME NULL",
    "ALTER TABLE orders ADD COLUMN transaction_id VARCHAR(100) NULL",
    "ALTER TABLE orders ADD COLUMN approval_number VARCHAR(50) NULL",
    "ALTER TABLE orders ADD COLUMN supplier VARCHAR(100) NULL",
    "ALTER TABLE orders ADD COLUMN hotel VARCHAR(255) NULL",
    "ALTER TABLE orders ADD COLUMN room_type VARCHAR(100) NULL",
    "ALTER TABLE orders ADD COLUMN flight_number VARCHAR(50) NULL",
    "ALTER TABLE orders ADD COLUMN notes TEXT NULL",
    
    // drafts table
    "ALTER TABLE drafts ADD COLUMN receipt_number VARCHAR(50) NULL",
    "ALTER TABLE drafts ADD COLUMN receipt_url TEXT NULL",
    "ALTER TABLE drafts ADD COLUMN amount_paid DECIMAL(10,2) DEFAULT 0",
    "ALTER TABLE drafts ADD COLUMN payment_installments INT DEFAULT 1",
    "ALTER TABLE drafts ADD COLUMN payment_last4 VARCHAR(4) NULL",
    "ALTER TABLE drafts ADD COLUMN payment_card_brand VARCHAR(50) NULL",
    "ALTER TABLE drafts ADD COLUMN payment_approval VARCHAR(50) NULL"
];

$success = 0;
$skipped = 0;

foreach ($queries as $sql) {
    try {
        $pdo->exec($sql);
        preg_match('/ADD COLUMN (\w+)/', $sql, $m);
        echo "✅ " . ($m[1] ?? 'OK') . "<br>";
        $success++;
    } catch (Exception $e) {
        if (strpos($e->getMessage(), 'Duplicate') !== false) {
            preg_match('/ADD COLUMN (\w+)/', $sql, $m);
            echo "⏭️ " . ($m[1] ?? '') . " (קיים)<br>";
            $skipped++;
        } else {
            echo "❌ " . $e->getMessage() . "<br>";
        }
    }
}

// Create draft_payments table
try {
    $pdo->exec("CREATE TABLE IF NOT EXISTS draft_payments (
        id INT AUTO_INCREMENT PRIMARY KEY,
        draft_id INT NOT NULL,
        payer_name VARCHAR(255),
        amount DECIMAL(10,2) NOT NULL,
        transaction_id VARCHAR(100),
        payment_date DATETIME DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_draft_id (draft_id)
    )");
    echo "✅ draft_payments<br>";
} catch (Exception $e) {
    echo "⏭️ draft_payments (קיים)<br>";
}

echo "<br><h3 style='color:green'>✅ סיום! הוספו $success עמודות, $skipped כבר היו קיימות</h3>";
echo "<a href='drafts_list.php' style='font-size:1.2em'>➡️ חזרה לטיוטות</a>";
?>