<?php
// תיקון מבנה טבלת bank_transfers
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();

echo "<h2>🔧 תיקון טבלת bank_transfers</h2>";

// בדיקה אם עמודת status קיימת
$cols = $pdo->query("SHOW COLUMNS FROM bank_transfers LIKE 'status'")->fetchAll();

if (empty($cols)) {
    echo "<p style='color:red;'>❌ עמודת status לא קיימת! מוסיף...</p>";
    
    $pdo->exec("ALTER TABLE bank_transfers ADD COLUMN status VARCHAR(50) DEFAULT 'pending_verification'");
    echo "<p style='color:green;'>✅ עמודת status נוספה!</p>";
} else {
    echo "<p style='color:green;'>✅ עמודת status קיימת</p>";
    echo "<pre>";
    print_r($cols[0]);
    echo "</pre>";
}

// בדיקה אם עמודת reviewed_by קיימת
$cols = $pdo->query("SHOW COLUMNS FROM bank_transfers LIKE 'reviewed_by'")->fetchAll();
if (empty($cols)) {
    echo "<p style='color:red;'>❌ עמודת reviewed_by לא קיימת! מוסיף...</p>";
    $pdo->exec("ALTER TABLE bank_transfers ADD COLUMN reviewed_by INT NULL");
    echo "<p style='color:green;'>✅ עמודת reviewed_by נוספה!</p>";
} else {
    echo "<p style='color:green;'>✅ עמודת reviewed_by קיימת</p>";
}

// בדיקה אם עמודת reviewed_at קיימת
$cols = $pdo->query("SHOW COLUMNS FROM bank_transfers LIKE 'reviewed_at'")->fetchAll();
if (empty($cols)) {
    echo "<p style='color:red;'>❌ עמודת reviewed_at לא קיימת! מוסיף...</p>";
    $pdo->exec("ALTER TABLE bank_transfers ADD COLUMN reviewed_at DATETIME NULL");
    echo "<p style='color:green;'>✅ עמודת reviewed_at נוספה!</p>";
} else {
    echo "<p style='color:green;'>✅ עמודת reviewed_at קיימת</p>";
}

// בדיקה אם עמודת rejection_reason קיימת
$cols = $pdo->query("SHOW COLUMNS FROM bank_transfers LIKE 'rejection_reason'")->fetchAll();
if (empty($cols)) {
    echo "<p style='color:red;'>❌ עמודת rejection_reason לא קיימת! מוסיף...</p>";
    $pdo->exec("ALTER TABLE bank_transfers ADD COLUMN rejection_reason TEXT NULL");
    echo "<p style='color:green;'>✅ עמודת rejection_reason נוספה!</p>";
} else {
    echo "<p style='color:green;'>✅ עמודת rejection_reason קיימת</p>";
}

echo "<hr>";

// הצגת מבנה הטבלה המלא
echo "<h3>מבנה הטבלה הנוכחי:</h3>";
$allCols = $pdo->query("SHOW COLUMNS FROM bank_transfers")->fetchAll(PDO::FETCH_ASSOC);
echo "<table border='1' style='border-collapse:collapse;'>";
echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Default</th></tr>";
foreach ($allCols as $col) {
    echo "<tr><td>{$col['Field']}</td><td>{$col['Type']}</td><td>{$col['Null']}</td><td>{$col['Default']}</td></tr>";
}
echo "</table>";

echo "<hr>";

// הצגת נתונים
echo "<h3>נתונים בטבלה:</h3>";
$rows = $pdo->query("SELECT id, status, amount, reviewed_by, reviewed_at FROM bank_transfers ORDER BY id DESC LIMIT 10")->fetchAll(PDO::FETCH_ASSOC);
echo "<table border='1' style='border-collapse:collapse;'>";
echo "<tr><th>ID</th><th>Status</th><th>Amount</th><th>Reviewed By</th><th>Reviewed At</th></tr>";
foreach ($rows as $row) {
    $st = $row['status'] ?? '<em>NULL</em>';
    echo "<tr><td>{$row['id']}</td><td>{$st}</td><td>{$row['amount']}</td><td>{$row['reviewed_by']}</td><td>{$row['reviewed_at']}</td></tr>";
}
echo "</table>";

echo "<hr>";
echo "<p><a href='bank_transfers.php'>← חזרה להעברות בנקאיות</a></p>";
?>
