<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// תיקון קידוד יעדים
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();

try {
    // הגדרת UTF-8
    $pdo->exec("SET NAMES utf8mb4");
    
    // שינוי קידוד הטבלה
    $pdo->exec("ALTER TABLE settings_destinations CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    
    // מחיקת הנתונים הקיימים
    $pdo->exec("DELETE FROM settings_destinations");
    
    // הכנסה מחדש עם קידוד נכון
    $destinations = array(
        array('בודפשט', 'הונגריה', 1),
        array('פראג', 'צכיה', 2),
        array('ברצלונה', 'ספרד', 3),
        array('רומא', 'איטליה', 4),
        array('וינה', 'אוסטריה', 5),
        array('אתונה', 'יוון', 6),
        array('קרקוב', 'פולין', 7),
        array('ורשה', 'פולין', 8),
        array('אמסטרדם', 'הולנד', 9),
        array('פריז', 'צרפת', 10),
        array('לונדון', 'אנגליה', 11),
        array('ליסבון', 'פורטוגל', 12),
        array('מדריד', 'ספרד', 13),
        array('מילאנו', 'איטליה', 14),
        array('ונציה', 'איטליה', 15),
        array('דובאי', 'איחוד האמירויות', 16),
        array('לרנקה', 'קפריסין', 17),
        array('פאפוס', 'קפריסין', 18),
        array('רודוס', 'יוון', 19),
        array('סנטוריני', 'יוון', 20),
        array('איסטנבול', 'טורקיה', 21),
        array('אנטליה', 'טורקיה', 22),
        array('בנגקוק', 'תאילנד', 23),
        array('טביליסי', 'גאורגיה', 24),
        array('באטומי', 'גאורגיה', 25)
    );
    
    $stmt = $pdo->prepare("INSERT INTO settings_destinations (name, country, sort_order) VALUES (?, ?, ?)");
    
    $count = 0;
    foreach ($destinations as $d) {
        $stmt->execute($d);
        $count++;
    }
    
    echo "<h1 style='color:green;'>✅ היעדים תוקנו!</h1>";
    echo "<p>נוספו " . $count . " יעדים</p>";
    echo "<p><a href='settings.php?tab=destinations'>חזור להגדרות</a></p>";
    
} catch (Exception $e) {
    echo "<h1 style='color:red;'>שגיאה!</h1>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>
