<?php
// תיקון סטטוס תשלום לספקים
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$message = '';

// עדכון סטטוס
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $orderId = (int)$_POST['order_id'];
    $flightStatus = $_POST['flight_status'];
    $hotelStatus = $_POST['hotel_status'];
    
    $stmt = $pdo->prepare("UPDATE orders SET flight_supplier_paid = ?, hotel_supplier_paid = ? WHERE id = ?");
    $stmt->execute([$flightStatus, $hotelStatus, $orderId]);
    $message = "הזמנה #$orderId עודכנה!";
}

// שליפת הזמנות
$orders = $pdo->query("
    SELECT id, destination, departure_date,
           flight_supplier, flight_supplier_cost, flight_supplier_currency, flight_supplier_paid,
           hotel_supplier, hotel_supplier_cost, hotel_supplier_currency, hotel_supplier_paid
    FROM orders 
    ORDER BY id DESC
")->fetchAll();
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>עדכון סטטוס תשלום לספקים</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; }
        h1 { color: #1e3c72; }
        .message { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        th, td { padding: 12px; text-align: right; border-bottom: 1px solid #eee; }
        th { background: #1e3c72; color: white; }
        tr:hover { background: #f8f9fa; }
        select { padding: 8px; border-radius: 5px; border: 1px solid #ddd; }
        select.unpaid { background: #fff3cd; }
        select.paid { background: #d4edda; }
        .btn { background: #e94560; color: white; border: none; padding: 8px 15px; border-radius: 5px; cursor: pointer; }
        .btn:hover { background: #d63050; }
        .supplier-info { font-size: 0.85rem; color: #666; }
        .nav { margin-bottom: 20px; }
        .nav a { margin-left: 15px; color: #1e3c72; }
    </style>
</head>
<body>
    <div class="container">
        <div class="nav">
            <a href="orders_new.php">📋 הזמנות</a>
            <a href="supplier_debts.php">💰 חובות לספקים</a>
            <a href="complete_order.php">➕ הזמנה חדשה</a>
        </div>
        
        <h1>🔧 עדכון סטטוס תשלום לספקים</h1>
        
        <?php if ($message): ?>
            <div class="message">✅ <?= $message ?></div>
        <?php endif; ?>
        
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>יעד</th>
                    <th>תאריך</th>
                    <th>ספק טיסה</th>
                    <th>עלות טיסה</th>
                    <th>סטטוס טיסה</th>
                    <th>ספק מלון</th>
                    <th>עלות מלון</th>
                    <th>סטטוס מלון</th>
                    <th>פעולה</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orders as $order): ?>
                <form method="POST">
                    <input type="hidden" name="order_id" value="<?= $order['id'] ?>">
                    <tr>
                        <td><?= $order['id'] ?></td>
                        <td><?= htmlspecialchars($order['destination']) ?></td>
                        <td><?= $order['departure_date'] ?></td>
                        <td>
                            <?= htmlspecialchars($order['flight_supplier'] ?: 'ישיר') ?>
                        </td>
                        <td>
                            <?php 
                            $symbol = $order['flight_supplier_currency'] === 'USD' ? '$' : ($order['flight_supplier_currency'] === 'EUR' ? '€' : '₪');
                            echo $symbol . number_format($order['flight_supplier_cost'], 2);
                            ?>
                        </td>
                        <td>
                            <select name="flight_status" class="<?= $order['flight_supplier_paid'] ?>">
                                <option value="paid" <?= $order['flight_supplier_paid'] === 'paid' ? 'selected' : '' ?>>✅ שולם</option>
                                <option value="unpaid" <?= $order['flight_supplier_paid'] === 'unpaid' ? 'selected' : '' ?>>⏳ טרם שולם</option>
                            </select>
                        </td>
                        <td>
                            <?= htmlspecialchars($order['hotel_supplier'] ?: 'ישיר') ?>
                        </td>
                        <td>
                            <?php 
                            $symbol = $order['hotel_supplier_currency'] === 'USD' ? '$' : ($order['hotel_supplier_currency'] === 'EUR' ? '€' : '₪');
                            echo $symbol . number_format($order['hotel_supplier_cost'], 2);
                            ?>
                        </td>
                        <td>
                            <select name="hotel_status" class="<?= $order['hotel_supplier_paid'] ?>">
                                <option value="paid" <?= $order['hotel_supplier_paid'] === 'paid' ? 'selected' : '' ?>>✅ שולם</option>
                                <option value="unpaid" <?= $order['hotel_supplier_paid'] === 'unpaid' ? 'selected' : '' ?>>⏳ טרם שולם</option>
                            </select>
                        </td>
                        <td>
                            <button type="submit" class="btn">💾 שמור</button>
                        </td>
                    </tr>
                </form>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <p style="margin-top:20px; color:#666;">
            💡 שנה את הסטטוס ל"טרם שולם" ולחץ שמור. אח"כ בדוק את <a href="supplier_debts.php">דף החובות</a>.
        </p>
    </div>
</body>
</html>
