<?php
// הגדרות מערכת CRM - חופשה במבצע
// ============================================

// הגדרת אזור זמן - ישראל
date_default_timezone_set('Asia/Jerusalem');

// הגדרות דאטאבייס
define('DB_HOST', 'localhost');
define('DB_NAME', 'rushynzi_crm');
define('DB_USER', 'rushynzi_crm');
define('DB_PASS', '0%XV?whmSr_a');

// הגדרות כלליות
define('SITE_NAME', 'חופשה במבצע');
define('SITE_URL', 'https://hufshagroup.com/newprojectmillion');

// הגדרות אבטחה
define('SESSION_LIFETIME', 86400); // 24 שעות
define('SECURE_COOKIES', true);

// חיבור לדאטאבייס
function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        try {
            $pdo = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            // הגדרת timezone לישראל
            $pdo->exec("SET time_zone = '+02:00'");
        } catch (PDOException $e) {
            die("שגיאת התחברות לדאטאבייס");
        }
    }
    return $pdo;
}

// יצירת טוקן אקראי מאובטח
function generateToken($length = 32) {
    return bin2hex(random_bytes($length));
}

// פונקציית ניקוי קלט
function sanitize($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

// פונקציית פורמט תאריך עברי
function formatHebrewDate($date) {
    if (!$date || $date === '0000-00-00') return '-';
    try {
        $months = ['ינואר', 'פברואר', 'מרץ', 'אפריל', 'מאי', 'יוני', 
                   'יולי', 'אוגוסט', 'ספטמבר', 'אוקטובר', 'נובמבר', 'דצמבר'];
        $d = new DateTime($date);
        return $d->format('j') . ' ב' . $months[$d->format('n') - 1] . ' ' . $d->format('Y');
    } catch (Exception $e) {
        return '-';
    }
}

// פונקציית פורמט מחיר
function formatPrice($price) {
    return '₪' . number_format($price, 0, '.', ',');
}
