<?php
// עמוד התחברות
require_once 'includes/auth.php';

// אם כבר מחובר - הפנה בהתאם לתפקיד
if (isLoggedIn()) {
    $agent = getCurrentAgent();
    if ($agent && $agent['role'] === 'accountant') {
        header('Location: reports.php?report=accountant');
    } else {
        header('Location: complete_order.php');
    }
    exit;
}

$error = '';

// טיפול בהתחברות
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (login($username, $password)) {
        // הפניה בהתאם לתפקיד
        $agent = getCurrentAgent();
        if ($agent && $agent['role'] === 'accountant') {
            header('Location: reports.php?report=accountant');
        } else {
            header('Location: complete_order.php');
        }
        exit;
    } else {
        $error = 'שם משתמש או סיסמה שגויים';
    }
}
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>התחברות - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="login-container">
        <div class="card login-card">
            <div class="login-logo">
                ✈️ <span style="color: #e94560;">חופשה</span> במבצע
            </div>
            
            <?php if ($error): ?>
                <div class="error-message"><?= sanitize($error) ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label for="username">שם משתמש</label>
                    <input type="text" id="username" name="username" required autofocus>
                </div>
                
                <div class="form-group">
                    <label for="password">סיסמה</label>
                    <input type="password" id="password" name="password" required>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    התחבר
                </button>
            </form>
        </div>
    </div>
</body>
</html>
