<?php
// ניהול משתמשים - רק לאדמין
require_once 'includes/auth.php';
requireLogin();

$agent = getCurrentAgent();

// בדיקת הרשאת אדמין
if ($agent['role'] !== 'admin') {
    header('Location: complete_order_lite.php');
    exit;
}

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$message = '';
$messageType = '';

// טיפול בפעולות
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'create':
            $username = trim($_POST['username'] ?? '');
            $fullName = trim($_POST['full_name'] ?? '');
            $password = $_POST['password'] ?? '';
            $role = $_POST['role'] ?? 'agent';
            
            if (empty($username) || empty($fullName) || empty($password)) {
                $message = 'יש למלא את כל השדות';
                $messageType = 'error';
            } else {
                // בדיקה אם שם משתמש קיים
                $stmt = $pdo->prepare("SELECT id FROM agents WHERE username = ?");
                $stmt->execute([$username]);
                if ($stmt->fetch()) {
                    $message = 'שם משתמש כבר קיים';
                    $messageType = 'error';
                } else {
                    $hashedPassword = hashPassword($password);
                    $stmt = $pdo->prepare("INSERT INTO agents (username, password, full_name, role) VALUES (?, ?, ?, ?)");
                    $stmt->execute([$username, $hashedPassword, $fullName, $role]);
                    $message = "המשתמש {$fullName} נוצר בהצלחה";
                    $messageType = 'success';
                }
            }
            break;
            
        case 'update':
            $id = (int)$_POST['id'];
            $fullName = trim($_POST['full_name'] ?? '');
            $role = $_POST['role'] ?? 'agent';
            $newPassword = $_POST['new_password'] ?? '';
            
            if ($id && $fullName) {
                if (!empty($newPassword)) {
                    $hashedPassword = hashPassword($newPassword);
                    $stmt = $pdo->prepare("UPDATE agents SET full_name = ?, role = ?, password = ? WHERE id = ?");
                    $stmt->execute([$fullName, $role, $hashedPassword, $id]);
                    $message = "המשתמש עודכן בהצלחה (כולל סיסמה)";
                } else {
                    $stmt = $pdo->prepare("UPDATE agents SET full_name = ?, role = ? WHERE id = ?");
                    $stmt->execute([$fullName, $role, $id]);
                    $message = "המשתמש עודכן בהצלחה";
                }
                $messageType = 'success';
            }
            break;
            
        case 'toggle':
            $id = (int)$_POST['id'];
            if ($id && $id !== $agent['id']) { // לא לכבות את עצמך
                $pdo->prepare("UPDATE agents SET active = NOT active WHERE id = ?")->execute([$id]);
                $message = "סטטוס המשתמש עודכן";
                $messageType = 'success';
            }
            break;
            
        case 'delete':
            $id = (int)$_POST['id'];
            if ($id && $id !== $agent['id']) { // לא למחוק את עצמך
                // בדיקה אם יש הזמנות
                $stmt = $pdo->prepare("SELECT COUNT(*) FROM orders WHERE agent_id = ?");
                $stmt->execute([$id]);
                $orderCount = $stmt->fetchColumn();
                
                if ($orderCount > 0) {
                    $message = "לא ניתן למחוק - למשתמש יש {$orderCount} הזמנות";
                    $messageType = 'error';
                } else {
                    $pdo->prepare("DELETE FROM agents WHERE id = ?")->execute([$id]);
                    $message = "המשתמש נמחק";
                    $messageType = 'success';
                }
            }
            break;
    }
}

// שליפת כל המשתמשים
$agents = $pdo->query("
    SELECT a.*, 
           (SELECT COUNT(*) FROM orders WHERE agent_id = a.id) as order_count,
           (SELECT COUNT(*) FROM drafts WHERE agent_id = a.id) as draft_count
    FROM agents a 
    ORDER BY a.role DESC, a.full_name
")->fetchAll();

?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ניהול משתמשים - חופשה במבצע</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: Arial, sans-serif; background: #f5f7fa; min-height: 100vh; }
        
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; }
        .logo { font-size: 1.5rem; font-weight: bold; }
        .logo span { color: #ffd700; }
        .user-info { display: flex; align-items: center; gap: 15px; }
        .user-name { font-size: 0.9rem; }
        .btn-logout { background: rgba(255,255,255,0.2); color: white; padding: 8px 15px; border-radius: 5px; text-decoration: none; }
        
        .nav { background: white; padding: 10px 30px; border-bottom: 1px solid #e0e0e0; display: flex; gap: 10px; flex-wrap: wrap; }
        .nav-link { padding: 8px 16px; text-decoration: none; color: #666; border-radius: 5px; }
        .nav-link:hover { background: #f0f0f0; }
        .nav-link.active { background: #667eea; color: white; }
        
        .container { max-width: 1200px; margin: 30px auto; padding: 0 20px; }
        
        .page-title { font-size: 1.8rem; color: #333; margin-bottom: 20px; }
        
        .alert { padding: 15px 20px; border-radius: 8px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .alert-error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        
        .card { background: white; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); padding: 25px; margin-bottom: 20px; }
        .card-title { font-size: 1.2rem; color: #333; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 2px solid #667eea; }
        
        .form-row { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 15px; }
        .form-group { display: flex; flex-direction: column; gap: 5px; }
        .form-group label { font-weight: bold; color: #555; font-size: 0.9rem; }
        .form-group input, .form-group select { padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 1rem; }
        .form-group input:focus, .form-group select:focus { border-color: #667eea; outline: none; }
        
        .btn { padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; font-size: 1rem; }
        .btn-primary { background: #667eea; color: white; }
        .btn-primary:hover { background: #5a6fd6; }
        .btn-danger { background: #dc3545; color: white; }
        .btn-danger:hover { background: #c82333; }
        .btn-sm { padding: 5px 10px; font-size: 0.85rem; }
        
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px; text-align: right; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; font-weight: bold; color: #555; }
        tr:hover { background: #f8f9fa; }
        
        .badge { padding: 4px 10px; border-radius: 15px; font-size: 0.8rem; }
        .badge-admin { background: #667eea; color: white; }
        .badge-agent { background: #6c757d; color: white; }
        .badge-active { background: #28a745; color: white; }
        .badge-inactive { background: #dc3545; color: white; }
        
        .actions { display: flex; gap: 5px; }
        .btn-icon { width: 32px; height: 32px; border: none; border-radius: 5px; cursor: pointer; font-size: 1rem; }
        .btn-edit { background: #ffc107; }
        .btn-toggle { background: #17a2b8; color: white; }
        .btn-delete { background: #dc3545; color: white; }
        
        .modal-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1000; align-items: center; justify-content: center; }
        .modal-overlay.show { display: flex; }
        .modal { background: white; border-radius: 10px; padding: 25px; max-width: 500px; width: 90%; }
        .modal-title { font-size: 1.3rem; margin-bottom: 20px; }
        .modal-actions { display: flex; gap: 10px; justify-content: flex-end; margin-top: 20px; }
        
        .stats { display: flex; gap: 20px; margin-bottom: 20px; }
        .stat { background: white; border-radius: 10px; padding: 20px; text-align: center; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .stat-value { font-size: 2rem; font-weight: bold; color: #667eea; }
        .stat-label { color: #666; font-size: 0.9rem; }
        
        .password-hint { font-size: 0.8rem; color: #666; margin-top: 5px; }
    </style>
</head>
<body>
    <header class="header">
        <div class="logo">✈️ <span>חופשה</span> במבצע</div>
        <div class="user-info">
            <span class="user-name">👤 <?= htmlspecialchars($agent['full_name']) ?> (מנהל)</span>
            <a href="logout.php" class="btn-logout">🚪 התנתק</a>
        </div>
    </header>
    
    <nav class="nav">
        <a href="complete_order_lite.php" class="nav-link">⚡ הזמנה לייט</a>
        <a href="draft.php" class="nav-link">📋 טיוטה</a>
        <a href="drafts_list.php" class="nav-link">📑 טיוטות</a>
        <a href="orders_panel.php" class="nav-link">📊 פאנל הזמנות</a>
        <a href="reports.php" class="nav-link">📈 דוחות</a>
        <a href="settings.php" class="nav-link">⚙️ הגדרות</a>
        <a href="manage_agents.php" class="nav-link active">👥 משתמשים</a>
    </nav>
    
    <div class="container">
        <h1 class="page-title">👥 ניהול משתמשים</h1>
        
        <?php if ($message): ?>
            <div class="alert alert-<?= $messageType ?>"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        
        <div class="stats">
            <div class="stat">
                <div class="stat-value"><?= count($agents) ?></div>
                <div class="stat-label">משתמשים</div>
            </div>
            <div class="stat">
                <div class="stat-value"><?= count(array_filter($agents, fn($a) => $a['active'])) ?></div>
                <div class="stat-label">פעילים</div>
            </div>
            <div class="stat">
                <div class="stat-value"><?= count(array_filter($agents, fn($a) => $a['role'] === 'admin')) ?></div>
                <div class="stat-label">מנהלים</div>
            </div>
        </div>
        
        <!-- טופס הוספת משתמש -->
        <div class="card">
            <h2 class="card-title">➕ הוסף משתמש חדש</h2>
            <form method="POST">
                <input type="hidden" name="action" value="create">
                <div class="form-row">
                    <div class="form-group">
                        <label>שם מלא</label>
                        <input type="text" name="full_name" required placeholder="לדוגמה: דנה">
                    </div>
                    <div class="form-group">
                        <label>שם משתמש (באנגלית)</label>
                        <input type="text" name="username" required placeholder="לדוגמה: dana" pattern="[a-zA-Z0-9_]+" title="אותיות באנגלית ומספרים בלבד">
                    </div>
                    <div class="form-group">
                        <label>סיסמה</label>
                        <input type="text" name="password" required placeholder="סיסמה חזקה">
                        <div class="password-hint">מומלץ: אות גדולה + מספרים + סימן (לדוגמה: Dana2025!)</div>
                    </div>
                    <div class="form-group">
                        <label>תפקיד</label>
                        <select name="role">
                            <option value="agent">נציג</option>
                            <option value="admin">מנהל</option>
                        </select>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary">➕ הוסף משתמש</button>
            </form>
        </div>
        
        <!-- רשימת משתמשים -->
        <div class="card">
            <h2 class="card-title">📋 משתמשים קיימים</h2>
            <table>
                <thead>
                    <tr>
                        <th>שם</th>
                        <th>שם משתמש</th>
                        <th>תפקיד</th>
                        <th>סטטוס</th>
                        <th>הזמנות</th>
                        <th>טיוטות</th>
                        <th>פעולות</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($agents as $a): ?>
                    <tr>
                        <td><strong><?= htmlspecialchars($a['full_name']) ?></strong></td>
                        <td><?= htmlspecialchars($a['username']) ?></td>
                        <td>
                            <span class="badge badge-<?= $a['role'] ?>">
                                <?= $a['role'] === 'admin' ? '👑 מנהל' : '👤 נציג' ?>
                            </span>
                        </td>
                        <td>
                            <span class="badge badge-<?= $a['active'] ? 'active' : 'inactive' ?>">
                                <?= $a['active'] ? 'פעיל' : 'מושבת' ?>
                            </span>
                        </td>
                        <td><?= $a['order_count'] ?></td>
                        <td><?= $a['draft_count'] ?></td>
                        <td class="actions">
                            <button type="button" class="btn-icon btn-edit" onclick="openEditModal(<?= htmlspecialchars(json_encode($a)) ?>)" title="עריכה">✏️</button>
                            <?php if ($a['id'] !== $agent['id']): ?>
                                <form method="POST" style="display:inline;">
                                    <input type="hidden" name="action" value="toggle">
                                    <input type="hidden" name="id" value="<?= $a['id'] ?>">
                                    <button type="submit" class="btn-icon btn-toggle" title="<?= $a['active'] ? 'השבת' : 'הפעל' ?>">
                                        <?= $a['active'] ? '🔒' : '🔓' ?>
                                    </button>
                                </form>
                                <?php if ($a['order_count'] == 0): ?>
                                <form method="POST" style="display:inline;" onsubmit="return confirm('למחוק את המשתמש <?= htmlspecialchars($a['full_name']) ?>?')">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="id" value="<?= $a['id'] ?>">
                                    <button type="submit" class="btn-icon btn-delete" title="מחק">🗑️</button>
                                </form>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <!-- הסבר הרשאות -->
        <div class="card">
            <h2 class="card-title">🔐 הרשאות לפי תפקיד</h2>
            <table>
                <thead>
                    <tr>
                        <th>פעולה</th>
                        <th>👑 מנהל</th>
                        <th>👤 נציג</th>
                    </tr>
                </thead>
                <tbody>
                    <tr><td>יצירת הזמנה</td><td>✅</td><td>✅</td></tr>
                    <tr><td>צפייה בהזמנות</td><td>✅ כולן</td><td>✅ רק שלו</td></tr>
                    <tr><td>עריכת הזמנות</td><td>✅</td><td>❌</td></tr>
                    <tr><td>מחיקת הזמנות</td><td>✅</td><td>❌</td></tr>
                    <tr><td>טיוטות</td><td>✅ כולן</td><td>✅ רק שלו</td></tr>
                    <tr><td>דוחות</td><td>✅</td><td>❌</td></tr>
                    <tr><td>הגדרות</td><td>✅</td><td>❌</td></tr>
                    <tr><td>ניהול משתמשים</td><td>✅</td><td>❌</td></tr>
                </tbody>
            </table>
        </div>
    </div>
    
    <!-- מודל עריכה -->
    <div class="modal-overlay" id="editModal">
        <div class="modal">
            <h3 class="modal-title">✏️ עריכת משתמש</h3>
            <form method="POST" id="editForm">
                <input type="hidden" name="action" value="update">
                <input type="hidden" name="id" id="editId">
                <div class="form-group">
                    <label>שם מלא</label>
                    <input type="text" name="full_name" id="editFullName" required>
                </div>
                <div class="form-group">
                    <label>שם משתמש</label>
                    <input type="text" id="editUsername" disabled style="background: #eee;">
                </div>
                <div class="form-group">
                    <label>תפקיד</label>
                    <select name="role" id="editRole">
                        <option value="agent">נציג</option>
                        <option value="admin">מנהל</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>סיסמה חדשה (השאר ריק אם לא לשנות)</label>
                    <input type="text" name="new_password" placeholder="סיסמה חדשה">
                </div>
                <div class="modal-actions">
                    <button type="button" class="btn" onclick="closeEditModal()">ביטול</button>
                    <button type="submit" class="btn btn-primary">💾 שמור</button>
                </div>
            </form>
        </div>
    </div>
    
    <script>
    function openEditModal(agent) {
        document.getElementById('editId').value = agent.id;
        document.getElementById('editFullName').value = agent.full_name;
        document.getElementById('editUsername').value = agent.username;
        document.getElementById('editRole').value = agent.role;
        document.getElementById('editModal').classList.add('show');
    }
    
    function closeEditModal() {
        document.getElementById('editModal').classList.remove('show');
    }
    
    document.getElementById('editModal').addEventListener('click', function(e) {
        if (e.target === this) closeEditModal();
    });
    </script>
</body>
</html>
