-- Migration: Add receipt columns for Invoice4U integration
-- Run this SQL on your database

-- Add receipt columns to orders table
ALTER TABLE orders 
ADD COLUMN IF NOT EXISTS receipt_number VARCHAR(50) NULL,
ADD COLUMN IF NOT EXISTS receipt_url TEXT NULL,
ADD COLUMN IF NOT EXISTS receipt_date DATETIME NULL;

-- Add receipt columns to drafts table
ALTER TABLE drafts 
ADD COLUMN IF NOT EXISTS receipt_number VARCHAR(50) NULL,
ADD COLUMN IF NOT EXISTS receipt_url TEXT NULL;

-- Check if payment_installments exists in drafts
ALTER TABLE drafts 
ADD COLUMN IF NOT EXISTS payment_installments INT DEFAULT 1,
ADD COLUMN IF NOT EXISTS payment_last4 VARCHAR(4) NULL,
ADD COLUMN IF NOT EXISTS payment_card_brand VARCHAR(50) NULL,
ADD COLUMN IF NOT EXISTS payment_approval VARCHAR(50) NULL;

-- Show success message
SELECT 'Migration completed - Invoice4U receipt columns added' AS status;
