<?php
// קטע להוספת תוספות להזמנה - להוסיף לדף order_view.php או order_edit.php
// זה יכול להיות include או חלק מדף קיים

require_once 'includes/config.php';
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$orderId = $_GET['order_id'] ?? $_POST['order_id'] ?? 0;

if (!$orderId) {
    die('חסר מזהה הזמנה');
}

// טעינת הזמנה
$stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
$stmt->execute([$orderId]);
$order = $stmt->fetch();

if (!$order) {
    die('הזמנה לא נמצאה');
}

// טעינת ספקים
$suppliers = $pdo->query("SELECT * FROM settings_suppliers ORDER BY name")->fetchAll();

// שמירת תוספת
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_item'])) {
    $stmt = $pdo->prepare("INSERT INTO order_items (order_id, item_type, description, supplier, supplier_booking_code, supplier_cost, customer_price) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $orderId,
        $_POST['item_type'],
        $_POST['description'],
        $_POST['supplier'],
        $_POST['supplier_booking_code'],
        floatval($_POST['supplier_cost']),
        floatval($_POST['customer_price'])
    ]);
    header("Location: order_items_form.php?order_id=$orderId&added=1");
    exit;
}

// מחיקת תוספת
if (isset($_GET['delete_item'])) {
    $pdo->prepare("DELETE FROM order_items WHERE id = ? AND order_id = ?")->execute([$_GET['delete_item'], $orderId]);
    header("Location: order_items_form.php?order_id=$orderId&deleted=1");
    exit;
}

// טעינת תוספות קיימות
$stmt = $pdo->prepare("SELECT * FROM order_items WHERE order_id = ? ORDER BY id");
$stmt->execute([$orderId]);
$items = $stmt->fetchAll();

$itemTypes = [
    'luggage' => '🧳 כבודה',
    'insurance' => '🛡️ ביטוח',
    'tour' => '🎯 טיול/סיור',
    'transfer' => '🚐 העברה',
    'upgrade' => '⬆️ שדרוג',
    'other' => '📋 אחר'
];
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>תוספות להזמנה #<?= $orderId ?></title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: #f0f2f5; min-height: 100vh; padding: 20px; }
        
        .container { max-width: 900px; margin: 0 auto; }
        
        .header { background: linear-gradient(135deg, #1e3c72, #2a5298); color: white; padding: 20px; border-radius: 12px 12px 0 0; display: flex; justify-content: space-between; align-items: center; }
        .header h1 { font-size: 1.3rem; }
        .header a { color: white; text-decoration: none; background: rgba(255,255,255,0.2); padding: 8px 15px; border-radius: 6px; }
        
        .card { background: white; border-radius: 0 0 12px 12px; padding: 25px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        
        .order-info { background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 20px; display: flex; gap: 30px; flex-wrap: wrap; }
        .order-info div { }
        .order-info .label { color: #666; font-size: 0.85rem; }
        .order-info .value { font-weight: 600; }
        
        .alert { padding: 12px 15px; border-radius: 8px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; }
        
        h2 { color: #1e3c72; margin-bottom: 15px; font-size: 1.1rem; }
        
        .form-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 15px; margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: 500; font-size: 0.9rem; }
        .form-group input, .form-group select { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 6px; }
        
        .btn-add { background: #28a745; color: white; border: none; padding: 12px 25px; border-radius: 8px; cursor: pointer; font-size: 1rem; }
        .btn-add:hover { background: #218838; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th { background: #f8f9fa; padding: 12px; text-align: right; font-weight: 600; }
        td { padding: 12px; border-bottom: 1px solid #eee; }
        
        .type-badge { padding: 3px 10px; border-radius: 15px; font-size: 0.85rem; background: #e3f2fd; }
        .booking-code { font-family: monospace; background: #f0f0f0; padding: 2px 6px; border-radius: 4px; }
        
        .btn-delete { background: #dc3545; color: white; border: none; padding: 5px 10px; border-radius: 4px; cursor: pointer; font-size: 0.85rem; }
        
        .totals { background: #e8f5e9; padding: 15px; border-radius: 8px; margin-top: 20px; display: flex; justify-content: space-around; text-align: center; }
        .totals .value { font-size: 1.3rem; font-weight: bold; color: #2e7d32; }
        .totals .label { font-size: 0.85rem; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>➕ תוספות להזמנה #<?= $orderId ?></h1>
            <a href="order_view.php?id=<?= $orderId ?>">← חזרה להזמנה</a>
        </div>
        
        <div class="card">
            <div class="order-info">
                <div>
                    <div class="label">לקוח</div>
                    <div class="value"><?= htmlspecialchars($order['customer_name']) ?></div>
                </div>
                <div>
                    <div class="label">יעד</div>
                    <div class="value"><?= htmlspecialchars($order['destination']) ?></div>
                </div>
                <div>
                    <div class="label">תאריך</div>
                    <div class="value"><?= $order['departure_date'] ? date('d/m/Y', strtotime($order['departure_date'])) : '-' ?></div>
                </div>
            </div>
            
            <?php if (isset($_GET['added'])): ?>
            <div class="alert alert-success">✅ התוספת נשמרה!</div>
            <?php endif; ?>
            <?php if (isset($_GET['deleted'])): ?>
            <div class="alert alert-success">✅ התוספת נמחקה!</div>
            <?php endif; ?>
            
            <h2>הוסף תוספת חדשה</h2>
            <form method="POST">
                <input type="hidden" name="order_id" value="<?= $orderId ?>">
                <div class="form-grid">
                    <div class="form-group">
                        <label>סוג</label>
                        <select name="item_type" required>
                            <?php foreach ($itemTypes as $val => $label): ?>
                            <option value="<?= $val ?>"><?= $label ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>תיאור</label>
                        <input type="text" name="description" placeholder="מזוודה 23 ק״ג">
                    </div>
                    <div class="form-group">
                        <label>ספק</label>
                        <select name="supplier">
                            <option value="">-- בחר --</option>
                            <?php foreach ($suppliers as $s): ?>
                            <option value="<?= htmlspecialchars($s['name']) ?>"><?= htmlspecialchars($s['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>קוד הזמנה ספק</label>
                        <input type="text" name="supplier_booking_code">
                    </div>
                    <div class="form-group">
                        <label>עלות לספק ₪</label>
                        <input type="number" name="supplier_cost" step="0.01" value="0">
                    </div>
                    <div class="form-group">
                        <label>מחיר ללקוח ₪</label>
                        <input type="number" name="customer_price" step="0.01" value="0">
                    </div>
                </div>
                <button type="submit" name="add_item" class="btn-add">➕ הוסף תוספת</button>
            </form>
            
            <?php if (!empty($items)): ?>
            <h2 style="margin-top: 30px;">תוספות קיימות</h2>
            <table>
                <thead>
                    <tr>
                        <th>סוג</th>
                        <th>תיאור</th>
                        <th>ספק</th>
                        <th>קוד הזמנה</th>
                        <th>עלות</th>
                        <th>מחיר ללקוח</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($items as $item): ?>
                    <tr>
                        <td><span class="type-badge"><?= $itemTypes[$item['item_type']] ?? $item['item_type'] ?></span></td>
                        <td><?= htmlspecialchars($item['description']) ?></td>
                        <td><?= htmlspecialchars($item['supplier'] ?: '-') ?></td>
                        <td><?= $item['supplier_booking_code'] ? '<span class="booking-code">' . htmlspecialchars($item['supplier_booking_code']) . '</span>' : '-' ?></td>
                        <td>₪<?= number_format($item['supplier_cost']) ?></td>
                        <td>₪<?= number_format($item['customer_price']) ?></td>
                        <td><a href="?order_id=<?= $orderId ?>&delete_item=<?= $item['id'] ?>" onclick="return confirm('למחוק?')" class="btn-delete">🗑️</a></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <div class="totals">
                <div>
                    <div class="value">₪<?= number_format(array_sum(array_column($items, 'supplier_cost'))) ?></div>
                    <div class="label">סה"כ עלות לספקים</div>
                </div>
                <div>
                    <div class="value">₪<?= number_format(array_sum(array_column($items, 'customer_price'))) ?></div>
                    <div class="label">סה"כ מחיר ללקוח</div>
                </div>
                <div>
                    <div class="value">₪<?= number_format(array_sum(array_column($items, 'customer_price')) - array_sum(array_column($items, 'supplier_cost'))) ?></div>
                    <div class="label">רווח מתוספות</div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
