<?php
require_once 'includes/config.php';
$pdo = getDB();

echo "<h2>🔧 יצירת טבלת תוספות להזמנות</h2>";

$sql = "CREATE TABLE IF NOT EXISTS order_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id INT NOT NULL,
    item_type ENUM('luggage','insurance','tour','transfer','upgrade','other') NOT NULL,
    description VARCHAR(255),
    supplier VARCHAR(100),
    supplier_booking_code VARCHAR(100),
    supplier_cost DECIMAL(10,2) DEFAULT 0,
    customer_price DECIMAL(10,2) DEFAULT 0,
    supplier_paid TINYINT(1) DEFAULT 0,
    supplier_paid_date DATE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_order (order_id),
    INDEX idx_supplier (supplier),
    FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

try {
    $pdo->exec($sql);
    echo "✅ טבלת order_items נוצרה בהצלחה!<br><br>";
    echo "<a href='orders.php'>→ חזרה להזמנות</a>";
} catch (Exception $e) {
    echo "❌ שגיאה: " . $e->getMessage();
}
?>
