<?php
// רשימת הזמנות
require_once 'includes/auth.php';
requireLogin();

$agent = getCurrentAgent();
$pdo = getDB();

// פילטרים
$status_filter = $_GET['status'] ?? '';
$search = $_GET['search'] ?? '';
$agent_filter = $_GET['agent'] ?? '';

// בניית השאילתא
$where = [];
$params = [];

if ($status_filter) {
    $where[] = "o.status = ?";
    $params[] = $status_filter;
}

if ($search) {
    $where[] = "(o.destination LIKE ? OR o.customer_phone LIKE ? OR o.hotel_name LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

if ($agent_filter) {
    $where[] = "o.agent_id = ?";
    $params[] = $agent_filter;
}

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';

// קבלת ההזמנות
$sql = "SELECT o.*, a.full_name as agent_name 
        FROM orders o 
        JOIN agents a ON o.agent_id = a.id 
        $whereClause 
        ORDER BY o.created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$orders = $stmt->fetchAll();

// קבלת רשימת נציגים (לפילטר)
$agents = $pdo->query("SELECT id, full_name FROM agents")->fetchAll();

// בדיקת תשלומים בהעברה בנקאית
function hasBankTransfer($payments) {
    if (!$payments) return false;
    $arr = json_decode($payments, true);
    if (!is_array($arr)) return false;
    foreach ($arr as $p) {
        if (isset($p['method']) && $p['method'] === 'העברה בנקאית') {
            return true;
        }
    }
    return false;
}

// סטטוסים בעברית
$statusNames = [
    'draft' => 'טיוטה',
    'sent' => 'נשלח',
    'paid' => 'שולם',
    'confirmed' => 'אושר',
    'cancelled' => 'בוטל'
];

$statusColors = [
    'draft' => '#6c757d',
    'sent' => '#17a2b8',
    'paid' => '#28a745',
    'confirmed' => '#007bff',
    'cancelled' => '#dc3545'
];
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>רשימת הזמנות - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .header { display: flex; justify-content: space-between; align-items: center; padding: 15px 30px; background: white; box-shadow: 0 2px 10px rgba(0,0,0,0.1); flex-wrap: wrap; gap: 15px; }
        .main-nav { display: flex; gap: 5px; }
        .nav-link { padding: 10px 20px; text-decoration: none; color: #555; border-radius: 8px; font-weight: 500; transition: all 0.2s; }
        .nav-link:hover { background: #f0f0f0; color: #333; }
        .nav-link.active { background: #667eea; color: white; }
        @media (max-width: 900px) { .main-nav { order: 3; width: 100%; justify-content: center; } }
        
        .sub-nav { background: #f8f9fa; padding: 10px 30px; display: flex; gap: 10px; border-bottom: 1px solid #e0e0e0; flex-wrap: wrap; }
        .sub-link { padding: 8px 15px; text-decoration: none; color: #666; border-radius: 6px; font-size: 0.9rem; }
        .sub-link:hover { background: #e9ecef; }
        .sub-link.active { background: white; color: #667eea; font-weight: 600; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        
        .filters {
            display: flex;
            gap: 15px;
            margin-bottom: 20px;
            flex-wrap: wrap;
            align-items: center;
        }
        .filters select, .filters input {
            padding: 10px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 0.95rem;
        }
        .orders-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        .orders-table th, .orders-table td {
            padding: 12px 15px;
            text-align: right;
            border-bottom: 1px solid #eee;
        }
        .orders-table th {
            background: #f8f9fa;
            font-weight: 600;
            color: #333;
        }
        .orders-table tr:hover {
            background: #f8f9fa;
        }
        .status-badge {
            padding: 5px 12px;
            border-radius: 20px;
            color: white;
            font-size: 0.85rem;
        }
        .bank-alert {
            background: #fff3cd;
            color: #856404;
            padding: 3px 8px;
            border-radius: 4px;
            font-size: 0.8rem;
            margin-right: 5px;
        }
        .action-btn {
            padding: 6px 12px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 0.85rem;
            text-decoration: none;
            display: inline-block;
        }
        .action-btn-view { background: #17a2b8; color: white; }
        .action-btn-edit { background: #ffc107; color: #333; }
        .summary-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 25px;
        }
        .summary-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
        }
        .summary-card.green { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }
        .summary-card.orange { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); }
        .summary-card h3 { font-size: 2rem; margin: 0; }
        .summary-card p { margin: 5px 0 0; opacity: 0.9; }
        .no-orders {
            text-align: center;
            padding: 50px;
            color: #666;
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="logo">✈️ <span>חופשה</span> במבצע</div>
        <nav class="main-nav">
            <a href="complete_order_lite.php" class="nav-link">⚡ הזמנה לייט</a>
            <a href="drafts_list.php" class="nav-link">📋 טיוטות</a>
            <a href="orders.php" class="nav-link active">📊 ניהול הזמנות</a>
            <a href="orders_panel.php" class="nav-link">🔍 פאנל מתקדם</a>
            <a href="reports.php" class="nav-link">📈 דוחות</a>
            <a href="settings.php" class="nav-link">⚙️ הגדרות</a>
        </nav>
        <div class="user-info">
            <span class="user-name">שלום, <?= sanitize($agent['full_name']) ?></span>
            <a href="logout.php" class="btn-logout">התנתק</a>
        </div>
    </header>
    
    <!-- תפריט משני -->
    <div class="sub-nav">
        <a href="orders.php" class="sub-link active">📋 רשימת הזמנות</a>
        <a href="manage_orders.php" class="sub-link">📅 ניהול מתקדם</a>
        <a href="supplier_debts.php" class="sub-link">💳 חובות ספקים</a>
        <a href="bank_transfers.php" class="sub-link">💰 העברות בנקאיות</a>
    </div>

    <div class="container" style="max-width:1200px;">
        <div class="card">
            <h1 class="card-title">📋 רשימת הזמנות</h1>

            <!-- סיכום -->
            <div class="summary-cards">
                <div class="summary-card">
                    <h3><?= count($orders) ?></h3>
                    <p>סה"כ הזמנות</p>
                </div>
                <div class="summary-card green">
                    <h3>₪<?= number_format(array_sum(array_column($orders, 'total_price'))) ?></h3>
                    <p>סה"כ מכירות</p>
                </div>
                <div class="summary-card orange">
                    <h3>₪<?= number_format(array_sum(array_column($orders, 'profit'))) ?></h3>
                    <p>סה"כ רווח</p>
                </div>
            </div>

            <!-- פילטרים -->
            <form method="GET" class="filters">
                <input type="text" name="search" placeholder="🔍 חיפוש יעד / טלפון / מלון" value="<?= sanitize($search) ?>">
                
                <select name="status">
                    <option value="">כל הסטטוסים</option>
                    <?php foreach ($statusNames as $key => $name): ?>
                        <option value="<?= $key ?>" <?= $status_filter === $key ? 'selected' : '' ?>><?= $name ?></option>
                    <?php endforeach; ?>
                </select>
                
                <select name="agent">
                    <option value="">כל הנציגים</option>
                    <?php foreach ($agents as $a): ?>
                        <option value="<?= $a['id'] ?>" <?= $agent_filter == $a['id'] ? 'selected' : '' ?>><?= sanitize($a['full_name']) ?></option>
                    <?php endforeach; ?>
                </select>
                
                <button type="submit" class="btn btn-primary" style="padding:10px 20px;">סנן</button>
                <a href="orders.php" style="color:#666;">נקה</a>
            </form>

            <!-- טבלת הזמנות -->
            <?php if (empty($orders)): ?>
                <div class="no-orders">
                    <h3>😕 לא נמצאו הזמנות</h3>
                    <p>נסה לשנות את הפילטרים או <a href="index.php">צור הזמנה חדשה</a></p>
                </div>
            <?php else: ?>
                <table class="orders-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>תאריך</th>
                            <th>יעד</th>
                            <th>לקוח</th>
                            <th>מחיר</th>
                            <th>רווח</th>
                            <th>נציג</th>
                            <th>סטטוס</th>
                            <th>פעולות</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($orders as $order): ?>
                            <tr>
                                <td><?= $order['id'] ?></td>
                                <td><?= date('d/m/Y', strtotime($order['created_at'])) ?></td>
                                <td>
                                    <strong><?= sanitize($order['destination']) ?></strong>
                                    <?php if (hasBankTransfer($order['payments'])): ?>
                                        <span class="bank-alert">💰 העברה בנקאית</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= sanitize($order['customer_phone']) ?></td>
                                <td>₪<?= number_format($order['total_price']) ?></td>
                                <td>₪<?= number_format($order['profit'] ?? 0) ?></td>
                                <td><?= sanitize($order['agent_name']) ?></td>
                                <td>
                                    <span class="status-badge" style="background:<?= $statusColors[$order['status']] ?? '#6c757d' ?>">
                                        <?= $statusNames[$order['status']] ?? $order['status'] ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="view_order.php?id=<?= $order['id'] ?>" class="action-btn action-btn-view">👁️</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
