<?php
// דף תשלום ללקוח - ציבורי (לא דורש התחברות)
require_once 'includes/config.php';

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$error = '';
$draft = null;

// בדיקת token
$token = $_GET['token'] ?? '';

if (!$token) {
    $error = 'לינק לא תקין';
} else {
    $stmt = $pdo->prepare("SELECT d.*, a.full_name as agent_name FROM drafts d JOIN agents a ON d.agent_id = a.id WHERE d.token = ?");
    $stmt->execute([$token]);
    $draft = $stmt->fetch();
    
    if (!$draft) {
        $error = 'הצעת המחיר לא נמצאה';
    } elseif ($draft['status'] === 'expired' || ($draft['expires_at'] && strtotime($draft['expires_at']) < time())) {
        $error = 'תוקף ההצעה פג. אנא צור קשר לקבלת הצעה חדשה';
    } elseif ($draft['status'] === 'cancelled') {
        $error = 'הצעה זו בוטלה';
    } else {
        // עדכון סטטוס לנצפה
        if ($draft['status'] === 'sent') {
            $pdo->prepare("UPDATE drafts SET status = 'viewed', viewed_at = NOW() WHERE id = ?")->execute([$draft['id']]);
        }
    }
}

// חישוב סכומים
$totalPrice = $draft['total_price'] ?? 0;
$amountPaid = $draft['amount_paid'] ?? 0;
$remaining = $totalPrice - $amountPaid;
$isFullyPaid = $remaining <= 0;

// שליפת תשלומים קודמים
$previousPayments = [];
if ($draft) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM draft_payments WHERE draft_id = ? ORDER BY payment_date");
        $stmt->execute([$draft['id']]);
        $previousPayments = $stmt->fetchAll();
    } catch (Exception $e) {
        // טבלה לא קיימת עדיין
    }
}

// חישוב לילות
$nights = 0;
if ($draft && $draft['departure_date'] && $draft['return_date']) {
    $nights = (strtotime($draft['return_date']) - strtotime($draft['departure_date'])) / (60*60*24);
}

// בדיקה אם זו תוספת
$isAddition = !empty($draft['parent_order_id']);
$additionDescription = $draft['addon_description'] ?? '';

$currencySymbols = ['ILS' => '₪', 'USD' => '$', 'EUR' => '€'];
$symbol = $currencySymbols[$draft['currency'] ?? 'ILS'] ?? '₪';
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>הצעת מחיר - חופשה במבצע</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px; }
        
        .container { max-width: 600px; margin: 0 auto; }
        
        .logo { text-align: center; color: white; font-size: 2rem; margin-bottom: 20px; }
        .logo span { color: #ffd700; }
        
        .card { background: white; border-radius: 20px; overflow: hidden; box-shadow: 0 20px 60px rgba(0,0,0,0.3); }
        
        .card-header { background: linear-gradient(135deg, #667eea, #764ba2); color: white; padding: 30px; text-align: center; }
        .card-header h1 { font-size: 1.5rem; margin-bottom: 10px; }
        .card-header .price { font-size: 2.5rem; font-weight: bold; }
        .card-header .price-note { font-size: 0.9rem; opacity: 0.9; }
        
        .card-body { padding: 30px; }
        
        .detail-section { margin-bottom: 25px; }
        .detail-section h3 { color: #667eea; font-size: 1.1rem; margin-bottom: 15px; display: flex; align-items: center; gap: 8px; }
        
        .detail-row { display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid #eee; }
        .detail-row:last-child { border-bottom: none; }
        .detail-label { color: #666; }
        .detail-value { font-weight: 600; color: #333; }
        
        .price-breakdown { background: #f8f9fa; padding: 20px; border-radius: 12px; margin: 25px 0; }
        .price-row { display: flex; justify-content: space-between; padding: 8px 0; }
        .price-row.total { border-top: 2px solid #667eea; margin-top: 10px; padding-top: 15px; font-size: 1.2rem; color: #667eea; font-weight: bold; }
        .price-row.paid { color: #28a745; }
        .price-row.remaining { color: #dc3545; font-weight: bold; font-size: 1.1rem; }
        
        .payment-status { padding: 20px; border-radius: 12px; margin-bottom: 20px; text-align: center; }
        .payment-status.partial { background: #fff3cd; border: 2px solid #ffc107; }
        .payment-status.full { background: #d4edda; border: 2px solid #28a745; }
        .payment-status h3 { margin-bottom: 10px; }
        .payment-status .amount { font-size: 1.5rem; font-weight: bold; }
        
        .previous-payments { background: #e8f5e9; padding: 15px; border-radius: 10px; margin-bottom: 20px; }
        .previous-payments h4 { color: #28a745; margin-bottom: 10px; }
        .previous-payments .payment-item { display: flex; justify-content: space-between; padding: 5px 0; border-bottom: 1px dashed #c8e6c9; }
        .previous-payments .payment-item:last-child { border-bottom: none; }
        
        .payment-options { margin: 20px 0; }
        .payment-options label { display: block; padding: 15px; border: 2px solid #e0e0e0; border-radius: 10px; margin-bottom: 10px; cursor: pointer; transition: all 0.2s; }
        .payment-options label:hover { border-color: #667eea; background: #fafafa; }
        .payment-options input[type="radio"] { margin-left: 10px; }
        .payment-options label.selected { border-color: #667eea; background: #f0f4ff; }
        
        .custom-amount { margin-top: 10px; padding: 15px; background: #f8f9fa; border-radius: 10px; display: none; }
        .custom-amount.show { display: block; }
        .custom-amount input { width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 1.2rem; text-align: center; }
        .custom-amount input:focus { border-color: #667eea; outline: none; }
        
        .payer-name { margin: 20px 0; }
        .payer-name label { display: block; margin-bottom: 8px; color: #666; font-weight: 500; }
        .payer-name input { width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 1rem; }
        .payer-name input:focus { border-color: #667eea; outline: none; }
        
        .btn-pay { display: block; width: 100%; background: linear-gradient(135deg, #28a745, #20c997); color: white; border: none; padding: 18px; font-size: 1.3rem; border-radius: 12px; cursor: pointer; font-weight: bold; margin-top: 20px; transition: transform 0.2s, box-shadow 0.2s; }
        .btn-pay:hover { transform: translateY(-2px); box-shadow: 0 5px 20px rgba(40, 167, 69, 0.4); }
        .btn-pay:disabled { background: #ccc; cursor: not-allowed; transform: none; box-shadow: none; }
        .btn-bank { background: linear-gradient(135deg, #667eea, #764ba2); }
        .btn-bank:hover { box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4); }
        
        /* טאבים לבחירת אמצעי תשלום */
        .payment-method-tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }
        .method-tab {
            flex: 1;
            padding: 15px;
            border: 2px solid #ddd;
            background: white;
            border-radius: 10px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 500;
            transition: all 0.3s;
        }
        .method-tab:hover {
            border-color: #667eea;
        }
        .method-tab.active {
            border-color: #667eea;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
        }
        
        /* פרטי חשבון בנק */
        .bank-details-box {
            background: #f8f9fa;
            border: 2px dashed #667eea;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
        }
        .bank-details-box h3 {
            margin-bottom: 15px;
            color: #333;
        }
        .bank-info {
            background: white;
            padding: 15px;
            border-radius: 8px;
        }
        .bank-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        .bank-row:last-child { border-bottom: none; }
        .bank-note {
            margin-top: 15px;
            padding: 10px;
            background: #fff3cd;
            border-radius: 8px;
            font-size: 0.9rem;
            color: #856404;
        }
        
        /* טופס העברה */
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 6px;
            font-weight: 500;
            color: #333;
        }
        .form-group input, .form-group textarea, .form-group select {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 1rem;
        }
        .form-group input:focus, .form-group textarea:focus {
            border-color: #667eea;
            outline: none;
        }
        .form-group input[type="file"] {
            padding: 10px;
            background: #f8f9fa;
        }
        #screenshotPreview img {
            max-width: 100%;
            max-height: 200px;
            margin-top: 10px;
            border-radius: 8px;
            border: 2px solid #ddd;
        }
        .bank-wait-note {
            text-align: center;
            color: #666;
            font-size: 0.9rem;
            margin-top: 15px;
        }
        
        .security-note { text-align: center; margin-top: 20px; color: #666; font-size: 0.9rem; }
        .security-note span { color: #28a745; }
        
        .expires { background: #fff3cd; color: #856404; padding: 12px; border-radius: 8px; text-align: center; margin-top: 20px; font-size: 0.9rem; }
        
        .error-container { background: white; border-radius: 20px; padding: 50px; text-align: center; }
        .error-container h1 { color: #dc3545; margin-bottom: 20px; }
        .error-container p { color: #666; margin-bottom: 20px; }
        
        .success-container { background: white; border-radius: 20px; padding: 50px; text-align: center; }
        .success-container h1 { color: #28a745; margin-bottom: 20px; }
        
        .contact-footer { background: #f8f9fa; padding: 20px; text-align: center; border-top: 1px solid #eee; }
        .contact-footer p { color: #666; margin-bottom: 10px; }
        .contact-footer .agent { font-weight: 600; color: #333; }
        
        @media (max-width: 480px) {
            .card-header .price { font-size: 2rem; }
            .btn-pay { font-size: 1.1rem; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">✈️ <span>חופשה</span> במבצע</div>
        
        <?php if ($error): ?>
            <div class="error-container">
                <h1>😕 אופס!</h1>
                <p><?= htmlspecialchars($error) ?></p>
                <p>לקבלת הצעה חדשה, צור קשר עם הנציג שלך</p>
            </div>
        <?php elseif ($isFullyPaid): ?>
            <div class="success-container">
                <h1>✅ ההזמנה שולמה במלואה!</h1>
                <p>תודה רבה! כל התשלומים התקבלו.</p>
                <p>הנציג שלך ייצור איתך קשר עם פרטים נוספים.</p>
            </div>
        <?php else: ?>
            <div class="card">
                <div class="card-header">
                    <?php if ($isAddition): ?>
                    <h1>📦 תשלום על תוספת</h1>
                    <div class="price"><?= $symbol ?><?= number_format($totalPrice) ?></div>
                    <div class="price-note"><?= htmlspecialchars($additionDescription) ?></div>
                    <?php else: ?>
                    <h1>🌴 הצעת מחיר לחופשה</h1>
                    <div class="price"><?= $symbol ?><?= number_format($totalPrice) ?></div>
                    <div class="price-note"><?= (int)$draft['num_passengers'] ?> נוסעים</div>
                    <?php endif; ?>
                </div>
                
                <div class="card-body">
                    <!-- פרטי הלקוח -->
                    <div class="detail-section">
                        <h3>👤 שלום <?= htmlspecialchars($draft['customer_name']) ?>!</h3>
                        <?php if ($isAddition): ?>
                        <p style="color:#666;">להלן פרטי התשלום על התוספת:</p>
                        <?php else: ?>
                        <p style="color:#666;">הנה פרטי החופשה שהזמנת:</p>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($amountPaid > 0): ?>
                    <!-- סטטוס תשלום חלקי -->
                    <div class="payment-status partial">
                        <h3>💰 סטטוס תשלום</h3>
                        <p>שולם: <span class="amount" style="color:#28a745;"><?= $symbol ?><?= number_format($amountPaid) ?></span></p>
                        <p>נותר לתשלום: <span class="amount" style="color:#dc3545;"><?= $symbol ?><?= number_format($remaining) ?></span></p>
                    </div>
                    
                    <!-- תשלומים קודמים -->
                    <?php if (count($previousPayments) > 0): ?>
                    <div class="previous-payments">
                        <h4>✅ תשלומים שבוצעו:</h4>
                        <?php foreach ($previousPayments as $payment): ?>
                        <div class="payment-item">
                            <span><?= htmlspecialchars($payment['payer_name'] ?: 'לקוח') ?></span>
                            <span><?= $symbol ?><?= number_format($payment['amount']) ?></span>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>
                    
                    <?php if ($isAddition): ?>
                    <!-- פרטי התוספת -->
                    <div class="detail-section">
                        <h3>📦 פרטי התוספת</h3>
                        <div class="detail-row">
                            <span class="detail-label">תיאור</span>
                            <span class="detail-value"><?= htmlspecialchars($additionDescription) ?></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">קשור להזמנה</span>
                            <span class="detail-value">#<?= $draft['parent_order_id'] ?></span>
                        </div>
                    </div>
                    
                    <!-- פירוט מחיר -->
                    <div class="price-breakdown">
                        <div class="price-row total">
                            <span>סה"כ לתשלום</span>
                            <span><?= $symbol ?><?= number_format($totalPrice) ?></span>
                        </div>
                    </div>
                    
                    <?php else: ?>
                    <!-- פרטי החופשה -->
                    <div class="detail-section">
                        <h3>🌍 פרטי החופשה</h3>
                        <div class="detail-row">
                            <span class="detail-label">יעד</span>
                            <span class="detail-value"><?= htmlspecialchars($draft['destination']) ?></span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">תאריכים</span>
                            <span class="detail-value">
                                <?= date('d/m/Y', strtotime($draft['departure_date'])) ?> - 
                                <?= date('d/m/Y', strtotime($draft['return_date'])) ?>
                                (<?= $nights ?> לילות)
                            </span>
                        </div>
                        <div class="detail-row">
                            <span class="detail-label">נוסעים</span>
                            <span class="detail-value"><?= (int)$draft['num_passengers'] ?></span>
                        </div>
                    </div>
                    
                    <?php if ($draft['airline']): ?>
                    <div class="detail-section">
                        <h3>✈️ טיסות</h3>
                        <div class="detail-row">
                            <span class="detail-label">חברת תעופה</span>
                            <span class="detail-value"><?= htmlspecialchars($draft['airline']) ?></span>
                        </div>
                        <?php if ($draft['flight_time_out']): ?>
                        <div class="detail-row">
                            <span class="detail-label">המראה</span>
                            <span class="detail-value"><?= substr($draft['flight_time_out'], 0, 5) ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if ($draft['flight_time_return']): ?>
                        <div class="detail-row">
                            <span class="detail-label">חזרה</span>
                            <span class="detail-value"><?= substr($draft['flight_time_return'], 0, 5) ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($draft['hotel_name']): ?>
                    <div class="detail-section">
                        <h3>🏨 מלון</h3>
                        <div class="detail-row">
                            <span class="detail-label">שם המלון</span>
                            <span class="detail-value">
                                <?= htmlspecialchars($draft['hotel_name']) ?>
                                <?php if ($draft['hotel_stars']): ?>
                                    <?= str_repeat('⭐', $draft['hotel_stars']) ?>
                                <?php endif; ?>
                            </span>
                        </div>
                        <?php if ($draft['board_basis']): ?>
                        <div class="detail-row">
                            <span class="detail-label">בסיס לינה</span>
                            <span class="detail-value">
                                <?php
                                $boardNames = ['BB' => 'ארוחת בוקר', 'HB' => 'חצי פנסיון', 'FB' => 'פנסיון מלא', 'RO' => 'לינה בלבד', 'AI' => 'הכל כלול'];
                                echo $boardNames[$draft['board_basis']] ?? $draft['board_basis'];
                                ?>
                            </span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($draft['notes']): ?>
                    <div class="detail-section">
                        <h3>📝 הערות</h3>
                        <p style="color:#666;"><?= nl2br(htmlspecialchars($draft['notes'])) ?></p>
                    </div>
                    <?php endif; ?>
                    
                    <!-- פירוט מחיר -->
                    <div class="price-breakdown">
                        <div class="price-row">
                            <span>מחיר לאדם</span>
                            <span><?= $symbol ?><?= number_format($draft['price_per_person']) ?></span>
                        </div>
                        <div class="price-row">
                            <span>מספר נוסעים</span>
                            <span>× <?= (int)$draft['num_passengers'] ?></span>
                        </div>
                        <div class="price-row total">
                            <span>סה"כ להזמנה</span>
                            <span><?= $symbol ?><?= number_format($totalPrice) ?></span>
                        </div>
                        <?php if ($amountPaid > 0): ?>
                        <div class="price-row paid">
                            <span>✅ שולם</span>
                            <span>-<?= $symbol ?><?= number_format($amountPaid) ?></span>
                        </div>
                        <div class="price-row remaining">
                            <span>נותר לתשלום</span>
                            <span><?= $symbol ?><?= number_format($remaining) ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?> <!-- סוף else של isAddition -->
                    
                    <!-- טופס תשלום -->
                    <form action="process_payment.php" method="POST" id="paymentForm">
                        <input type="hidden" name="token" value="<?= htmlspecialchars($token) ?>">
                        <input type="hidden" name="max_amount" value="<?= $remaining ?>">
                        
                        <!-- שם המשלם -->
                        <div class="payer-name">
                            <label for="payer_name">👤 שם המשלם:</label>
                            <input type="text" name="payer_name" id="payer_name" required 
                                   value="<?= htmlspecialchars($draft['customer_name']) ?>"
                                   placeholder="הכנס את שמך">
                        </div>
                        
                        <!-- מייל לקבלה -->
                        <div class="payer-name">
                            <label for="payer_email">📧 מייל לקבלה:</label>
                            <input type="email" name="payer_email" id="payer_email" required 
                                   placeholder="example@email.com">
                        </div>
                        
                        <!-- בחירת אמצעי תשלום -->
                        <div class="payment-method-tabs">
                            <button type="button" class="method-tab active" onclick="showPaymentMethod('credit')">
                                💳 כרטיס אשראי
                            </button>
                            <button type="button" class="method-tab" onclick="showPaymentMethod('bank')">
                                🏦 העברה בנקאית
                            </button>
                        </div>
                        
                        <!-- תשלום בכרטיס אשראי -->
                        <div id="creditPayment" class="payment-method-content">
                        
                        <!-- בחירת סכום -->
                        <div class="detail-section">
                            <h3>💳 בחר סכום לתשלום:</h3>
                            
                            <div class="payment-options">
                                <label onclick="selectOption(this, 'full')">
                                    <input type="radio" name="payment_type" value="full" checked>
                                    <span>שלם את הכל - <?= $symbol ?><?= number_format($remaining) ?></span>
                                </label>
                                
                                <?php if ($draft['num_passengers'] > 1 && $draft['price_per_person'] <= $remaining): ?>
                                <?php $perPerson = $draft['price_per_person']; ?>
                                <label onclick="selectOption(this, 'per_person')">
                                    <input type="radio" name="payment_type" value="per_person">
                                    <span>שלם עבור אדם אחד - <?= $symbol ?><?= number_format($perPerson) ?></span>
                                </label>
                                <?php endif; ?>
                                
                                <label onclick="selectOption(this, 'custom')">
                                    <input type="radio" name="payment_type" value="custom">
                                    <span>סכום אחר</span>
                                </label>
                            </div>
                            
                            <div class="custom-amount" id="customAmountDiv">
                                <input type="number" name="custom_amount" id="customAmount" 
                                       min="1" max="<?= $remaining ?>" step="1"
                                       placeholder="הכנס סכום (עד <?= $symbol ?><?= number_format($remaining) ?>)">
                            </div>
                        </div>
                        
                        <button type="submit" class="btn-pay" id="payBtn">
                            💳 לתשלום מאובטח
                        </button>
                        
                        </div>
                    </form>
                    
                    <!-- תשלום בהעברה בנקאית -->
                    <div id="bankPayment" class="payment-method-content" style="display:none;">
                        <div class="bank-details-box">
                            <h3>🏦 פרטי חשבון להעברה:</h3>
                            <div class="bank-info">
                                <div class="bank-row"><span>בנק:</span> <strong>מזרחי טפחות (20)</strong></div>
                                <div class="bank-row"><span>סניף:</span> <strong>592</strong></div>
                                <div class="bank-row"><span>מספר חשבון:</span> <strong>108816</strong></div>
                                <div class="bank-row"><span>על שם:</span> <strong>חופשה במבצע בע"מ</strong></div>
                            </div>
                            <p class="bank-note">💡 ניתן להעביר גם דרך אפליקציית הבנק או ביט</p>
                        </div>
                        
                        <form action="api/submit_bank_transfer.php" method="POST" enctype="multipart/form-data" id="bankForm">
                            <input type="hidden" name="token" value="<?= htmlspecialchars($token) ?>">
                            <input type="hidden" name="draft_id" value="<?= $draft['id'] ?>">
                            <input type="hidden" name="payer_email" id="bankPayerEmail" value="">
                            <input type="hidden" name="transferrer_name" id="bankPayerName" value="">
                            
                            <div class="form-group">
                                <label>📱 טלפון</label>
                                <input type="tel" name="transferrer_phone" value="<?= htmlspecialchars($draft['customer_phone']) ?>">
                            </div>
                            
                            <div class="form-group">
                                <label>💰 סכום ההעברה</label>
                                <input type="number" name="amount" required min="1" max="<?= $remaining ?>" value="<?= $remaining ?>" step="0.01">
                            </div>
                            
                            <div class="form-group">
                                <label>📅 תאריך ההעברה</label>
                                <input type="date" name="transfer_date" required value="<?= date('Y-m-d') ?>">
                            </div>
                            
                            <div class="form-group">
                                <label>🔢 מספר אסמכתא (אופציונלי)</label>
                                <input type="text" name="reference_number" placeholder="מספר אסמכתא מהבנק">
                            </div>
                            
                            <div class="form-group">
                                <label>📸 צילום מסך של ההעברה</label>
                                <input type="file" name="screenshot" accept="image/*" required id="screenshotInput">
                                <div id="screenshotPreview"></div>
                            </div>
                            
                            <div class="form-group">
                                <label>📝 הערות (אופציונלי)</label>
                                <textarea name="notes" rows="2" placeholder="הערות נוספות..."></textarea>
                            </div>
                            
                            <button type="submit" class="btn-pay btn-bank">
                                📤 שלח אישור העברה
                            </button>
                        </form>
                        
                        <p class="bank-wait-note">
                            ✅ לאחר השליחה, הסכום יזוכה מיד ותוכלו להמשיך בתהליך ההזמנה
                        </p>
                    </div>
                    
                    <div class="security-note">
                        🔒 <span>תשלום מאובטח</span> באמצעות Cardcom
                    </div>
                    
                    <?php if ($draft['expires_at']): ?>
                    <div class="expires">
                        ⏰ ההצעה בתוקף עד: <?= date('d/m/Y H:i', strtotime($draft['expires_at'])) ?>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="contact-footer">
                    <p>שאלות? צור קשר עם הנציג שלך:</p>
                    <p class="agent">👤 <?= htmlspecialchars($draft['agent_name']) ?></p>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <script>
        const remaining = <?= $remaining ?>;
        const perPerson = <?= $draft['price_per_person'] ?? 0 ?>;
        const symbol = '<?= $symbol ?>';
        
        function selectOption(label, type) {
            // הסר selection מכולם
            document.querySelectorAll('.payment-options label').forEach(l => l.classList.remove('selected'));
            // סמן את הנבחר
            label.classList.add('selected');
            
            // הצג/הסתר שדה סכום מותאם
            const customDiv = document.getElementById('customAmountDiv');
            const customInput = document.getElementById('customAmount');
            
            if (type === 'custom') {
                customDiv.classList.add('show');
                customInput.required = true;
                customInput.focus();
            } else {
                customDiv.classList.remove('show');
                customInput.required = false;
            }
            
            updateButtonText(type);
        }
        
        function updateButtonText(type) {
            const btn = document.getElementById('payBtn');
            let amount = remaining;
            
            if (type === 'per_person') {
                amount = perPerson;
            } else if (type === 'custom') {
                amount = document.getElementById('customAmount').value || 0;
            }
            
            btn.textContent = '💳 לתשלום ' + symbol + Number(amount).toLocaleString();
        }
        
        // עדכון כפתור בשינוי סכום מותאם
        document.getElementById('customAmount')?.addEventListener('input', function() {
            updateButtonText('custom');
        });
        
        // סימון ראשוני
        document.querySelector('.payment-options label')?.classList.add('selected');
        updateButtonText('full');
        
        // החלפת אמצעי תשלום
        function showPaymentMethod(method) {
            // עדכון טאבים
            document.querySelectorAll('.method-tab').forEach(tab => tab.classList.remove('active'));
            event.target.classList.add('active');
            
            // הצגת התוכן המתאים
            document.getElementById('creditPayment').style.display = method === 'credit' ? 'block' : 'none';
            document.getElementById('bankPayment').style.display = method === 'bank' ? 'block' : 'none';
            
            // סנכרון שם ומייל לטופס העברה
            if (method === 'bank') {
                const email = document.getElementById('payer_email')?.value || '';
                const name = document.getElementById('payer_name')?.value || '';
                document.getElementById('bankPayerEmail').value = email;
                document.getElementById('bankPayerName').value = name;
            }
        }
        
        // תצוגה מקדימה של צילום מסך
        document.getElementById('screenshotInput')?.addEventListener('change', function(e) {
            const preview = document.getElementById('screenshotPreview');
            preview.innerHTML = '';
            
            if (e.target.files && e.target.files[0]) {
                const reader = new FileReader();
                reader.onload = function(ev) {
                    const img = document.createElement('img');
                    img.src = ev.target.result;
                    preview.appendChild(img);
                };
                reader.readAsDataURL(e.target.files[0]);
            }
        });
        
        // עדכון שם ומייל בטופס העברה כשמשנים
        document.getElementById('payer_email')?.addEventListener('input', function() {
            document.getElementById('bankPayerEmail').value = this.value;
        });
        document.getElementById('payer_name')?.addEventListener('input', function() {
            document.getElementById('bankPayerName').value = this.value;
        });
        
        // שליחת טופס העברה
        document.getElementById('bankForm')?.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            // וידוא שם ומייל
            const email = document.getElementById('payer_email')?.value || '';
            const name = document.getElementById('payer_name')?.value || '';
            if (!email) {
                alert('נא להזין כתובת אימייל לקבלת קבלה');
                document.getElementById('payer_email')?.focus();
                return;
            }
            if (!name) {
                alert('נא להזין שם משלם');
                document.getElementById('payer_name')?.focus();
                return;
            }
            document.getElementById('bankPayerEmail').value = email;
            document.getElementById('bankPayerName').value = name;
            
            const btn = this.querySelector('button[type="submit"]');
            btn.disabled = true;
            btn.textContent = '⏳ שולח...';
            
            try {
                const formData = new FormData(this);
                const response = await fetch('api/submit_bank_transfer.php', {
                    method: 'POST',
                    body: formData
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('✅ ' + result.message);
                    location.reload();
                } else {
                    alert('❌ שגיאה: ' + (result.error || 'לא ידוע'));
                    btn.disabled = false;
                    btn.textContent = '📤 שלח אישור העברה';
                }
            } catch (err) {
                alert('❌ שגיאה בשליחה: ' + err.message);
                btn.disabled = false;
                btn.textContent = '📤 שלח אישור העברה';
            }
        });
    </script>
</body>
</html>