<?php
// דף כישלון תשלום
require_once 'includes/config.php';

$token = $_GET['token'] ?? '';
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>התשלום נכשל - חופשה במבצע</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); min-height: 100vh; padding: 20px; display: flex; align-items: center; justify-content: center; }
        
        .container { max-width: 500px; width: 100%; }
        
        .card { background: white; border-radius: 20px; overflow: hidden; box-shadow: 0 20px 60px rgba(0,0,0,0.3); text-align: center; padding: 50px 40px; }
        
        .error-icon { font-size: 80px; margin-bottom: 20px; }
        
        h1 { color: #dc3545; margin-bottom: 15px; font-size: 1.8rem; }
        
        .message { color: #666; font-size: 1.1rem; margin-bottom: 30px; }
        
        .reasons { background: #f8f9fa; padding: 20px; border-radius: 12px; text-align: right; margin: 25px 0; }
        .reasons h3 { color: #333; margin-bottom: 10px; }
        .reasons ul { margin-right: 20px; color: #666; }
        .reasons li { margin: 8px 0; }
        
        .btn { display: inline-block; padding: 15px 40px; border-radius: 10px; text-decoration: none; font-size: 1.1rem; margin: 10px; font-weight: 600; }
        .btn-primary { background: linear-gradient(135deg, #667eea, #764ba2); color: white; }
        .btn-secondary { background: #6c757d; color: white; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="error-icon">❌</div>
            <h1>התשלום לא הושלם</h1>
            <p class="message">לצערנו, התשלום לא עבר. אפשר לנסות שוב.</p>
            
            <div class="reasons">
                <h3>סיבות אפשריות:</h3>
                <ul>
                    <li>פרטי כרטיס האשראי שגויים</li>
                    <li>אין מספיק מסגרת אשראי</li>
                    <li>הכרטיס חסום לעסקאות אינטרנט</li>
                    <li>בעיה טכנית זמנית</li>
                </ul>
            </div>
            
            <?php if ($token): ?>
            <a href="pay.php?token=<?= htmlspecialchars($token) ?>" class="btn btn-primary">🔄 נסה שוב</a>
            <?php endif; ?>
            
            <p style="margin-top: 30px; color: #666;">
                נתקלת בבעיה? צור קשר עם הנציג שלך לעזרה.
            </p>
        </div>
    </div>
</body>
</html>
