<?php
// דף הצלחת תשלום - תמיכה בתשלומים חלקיים
require_once 'includes/config.php';

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$token = $_GET['token'] ?? '';
$draft = null;
$lastPayment = null;

if ($token) {
    // המתנה קצרה לוודא שה-callback הספיק לעדכן
    usleep(500000); // 0.5 שניות
    
    $stmt = $pdo->prepare("SELECT d.*, a.full_name as agent_name FROM drafts d JOIN agents a ON d.agent_id = a.id WHERE d.token = ?");
    $stmt->execute([$token]);
    $draft = $stmt->fetch();
    
    // שליפת התשלום האחרון
    if ($draft) {
        try {
            $stmt = $pdo->prepare("SELECT * FROM draft_payments WHERE draft_id = ? ORDER BY payment_date DESC LIMIT 1");
            $stmt->execute([$draft['id']]);
            $lastPayment = $stmt->fetch();
        } catch (Exception $e) {
            // טבלה לא קיימת
        }
    }
}

$currencySymbols = ['ILS' => '₪', 'USD' => '$', 'EUR' => '€'];
$symbol = $draft ? ($currencySymbols[$draft['currency']] ?? '₪') : '₪';

// חישוב יתרה
$totalPrice = floatval($draft['total_price'] ?? 0);
$amountPaid = floatval($draft['amount_paid'] ?? 0);
$remaining = $totalPrice - $amountPaid;
$isFullyPaid = $remaining <= 0;

// אם עדיין לא עודכן - רענן את הדף
$needsRefresh = ($amountPaid == 0 && !isset($_GET['r']));
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>תשלום הצליח! - חופשה במבצע</title>
    <?php if ($needsRefresh): ?>
    <meta http-equiv="refresh" content="2;url=payment_success.php?token=<?= htmlspecialchars($token) ?>&r=1">
    <?php endif; ?>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: linear-gradient(135deg, #28a745 0%, #20c997 100%); min-height: 100vh; padding: 20px; display: flex; align-items: center; justify-content: center; }
        
        .container { max-width: 500px; width: 100%; }
        
        .card { background: white; border-radius: 20px; overflow: hidden; box-shadow: 0 20px 60px rgba(0,0,0,0.3); text-align: center; padding: 50px 40px; }
        
        .success-icon { font-size: 80px; margin-bottom: 20px; animation: bounce 0.5s; }
        @keyframes bounce { 0%, 100% { transform: scale(1); } 50% { transform: scale(1.2); } }
        
        h1 { color: #28a745; margin-bottom: 15px; font-size: 2rem; }
        
        .message { color: #666; font-size: 1.1rem; margin-bottom: 30px; }
        
        .details-box { background: #f8f9fa; padding: 25px; border-radius: 15px; text-align: right; margin: 25px 0; }
        .details-row { display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid #eee; }
        .details-row:last-child { border-bottom: none; }
        .details-label { color: #666; }
        .details-value { font-weight: 600; color: #333; }
        
        .total-paid { background: #28a745; color: white; padding: 20px; border-radius: 12px; margin: 20px 0; }
        .total-paid .amount { font-size: 2rem; font-weight: bold; }
        .total-paid .label { font-size: 0.9rem; opacity: 0.9; }
        
        .payment-summary { background: #f8f9fa; padding: 20px; border-radius: 12px; margin: 20px 0; }
        .summary-row { display: flex; justify-content: space-between; padding: 8px 0; }
        .summary-row.paid { color: #28a745; }
        .summary-row.remaining { color: #dc3545; font-weight: bold; font-size: 1.1rem; }
        
        .remaining-box { background: #fff3cd; border: 2px solid #ffc107; padding: 20px; border-radius: 12px; margin: 20px 0; }
        .remaining-box h3 { color: #856404; margin-bottom: 10px; }
        .remaining-box .amount { font-size: 1.5rem; font-weight: bold; color: #856404; }
        
        .btn-continue { display: inline-block; background: linear-gradient(135deg, #667eea, #764ba2); color: white; padding: 15px 30px; border-radius: 10px; text-decoration: none; font-weight: bold; margin-top: 15px; transition: transform 0.2s; }
        .btn-continue:hover { transform: translateY(-2px); }
        
        .next-steps { background: #e3f2fd; padding: 20px; border-radius: 12px; text-align: right; margin-top: 25px; }
        .next-steps h3 { color: #1976d2; margin-bottom: 10px; }
        .next-steps ul { margin-right: 20px; color: #555; }
        .next-steps li { margin: 8px 0; }
        
        .contact { margin-top: 30px; color: #666; }
        .contact strong { color: #333; }
        
        .loading { color: #666; font-size: 1rem; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="success-icon">✅</div>
            <h1>התשלום הצליח!</h1>
            <p class="message">תודה רבה! ההזמנה שלך אושרה.</p>
            
            <?php if ($draft): ?>
            
            <?php if ($needsRefresh): ?>
            <p class="loading">⏳ טוען נתונים...</p>
            <?php else: ?>
            
            <!-- סכום ששולם עכשיו -->
            <div class="total-paid">
                <div class="label">סה"כ שולם</div>
                <div class="amount"><?= $symbol ?><?= number_format($lastPayment['amount'] ?? $amountPaid) ?></div>
            </div>
            
            <!-- סיכום תשלומים -->
            <div class="payment-summary">
                <div class="summary-row">
                    <span>סה"כ להזמנה</span>
                    <span><?= $symbol ?><?= number_format($totalPrice) ?></span>
                </div>
                <div class="summary-row paid">
                    <span>✅ שולם עד כה</span>
                    <span><?= $symbol ?><?= number_format($amountPaid) ?></span>
                </div>
                <?php if (!$isFullyPaid): ?>
                <div class="summary-row remaining">
                    <span>נותר לתשלום</span>
                    <span><?= $symbol ?><?= number_format($remaining) ?></span>
                </div>
                <?php endif; ?>
            </div>
            
            <?php if (!$isFullyPaid): ?>
            <!-- יש עוד לשלם -->
            <div class="remaining-box">
                <h3>⏳ נותר לתשלום</h3>
                <div class="amount"><?= $symbol ?><?= number_format($remaining) ?></div>
                <a href="pay.php?token=<?= htmlspecialchars($token) ?>" class="btn-continue">
                    💳 לתשלום היתרה
                </a>
            </div>
            <?php endif; ?>
            
            <?php endif; ?>
            
            <div class="details-box">
                <div class="details-row">
                    <span class="details-label">יעד</span>
                    <span class="details-value"><?= htmlspecialchars($draft['destination']) ?></span>
                </div>
                <div class="details-row">
                    <span class="details-label">תאריכים</span>
                    <span class="details-value">
                        <?= date('d/m/Y', strtotime($draft['departure_date'])) ?> - 
                        <?= date('d/m/Y', strtotime($draft['return_date'])) ?>
                    </span>
                </div>
                <div class="details-row">
                    <span class="details-label">נוסעים</span>
                    <span class="details-value"><?= (int)$draft['num_passengers'] ?></span>
                </div>
            </div>
            
            <div class="next-steps">
                <h3>📋 מה עכשיו?</h3>
                <ul>
                    <li>קבלה תישלח למייל שלך בקרוב</li>
                    <li>הנציג שלך יצור איתך קשר עם פרטים נוספים</li>
                    <li>מסמכי הנסיעה יישלחו לפני היציאה</li>
                </ul>
            </div>
            
            <div class="contact">
                <p>שאלות? צור קשר עם הנציג שלך:</p>
                <p><strong>👤 <?= htmlspecialchars($draft['agent_name']) ?></strong></p>
            </div>
            <?php else: ?>
            <p>אישור התשלום נשמר במערכת.</p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>