<?php
// דף ניהול העברות בנקאיות - לנציגים
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$agent = getCurrentAgent();

// טיפול בפעולות
$message = '';
if ($_POST) {
    $action = $_POST['action'] ?? '';
    $transferId = (int)($_POST['transfer_id'] ?? 0);
    
    if ($transferId && $action) {
        if ($action === 'approve') {
            // אישור העברה
            $stmt = $pdo->prepare("UPDATE bank_transfers SET status = 'approved', reviewed_by = ?, reviewed_at = NOW() WHERE id = ?");
            $stmt->execute([$agent['id'], $transferId]);
            
            // קבלת פרטי ההעברה
            $stmt = $pdo->prepare("SELECT * FROM bank_transfers WHERE id = ?");
            $stmt->execute([$transferId]);
            $transfer = $stmt->fetch();
            
            if ($transfer && $transfer['draft_id']) {
                // עדכון הטיוטה
                $stmt = $pdo->prepare("SELECT * FROM drafts WHERE id = ?");
                $stmt->execute([$transfer['draft_id']]);
                $draft = $stmt->fetch();
                
                if ($draft) {
                    $currentPaid = floatval($draft['amount_paid'] ?? 0);
                    $newPaid = $currentPaid + $transfer['amount'];
                    $totalPrice = floatval($draft['total_price']);
                    $newStatus = ($newPaid >= $totalPrice) ? 'paid' : 'partial';
                    
                    $stmt = $pdo->prepare("UPDATE drafts SET amount_paid = ?, status = ?, payment_method = 'bank_transfer', payment_date = NOW() WHERE id = ?");
                    $stmt->execute([$newPaid, $newStatus, $transfer['draft_id']]);
                }
            }
            
            $message = '<div class="alert success">✅ ההעברה אושרה והסכום עודכן!</div>';
            
        } elseif ($action === 'reject') {
            $reason = $_POST['rejection_reason'] ?? '';
            $stmt = $pdo->prepare("UPDATE bank_transfers SET status = 'rejected', reviewed_by = ?, reviewed_at = NOW(), rejection_reason = ? WHERE id = ?");
            $stmt->execute([$agent['id'], $reason, $transferId]);
            $message = '<div class="alert warning">❌ ההעברה נדחתה</div>';
        }
    }
}

// סינון
$statusFilter = $_GET['status'] ?? 'pending';

// שליפת העברות
$sql = "SELECT bt.*, d.customer_name as draft_customer, d.destination, d.total_price, d.amount_paid,
               a.full_name as reviewer_name
        FROM bank_transfers bt
        LEFT JOIN drafts d ON bt.draft_id = d.id
        LEFT JOIN agents a ON bt.reviewed_by = a.id
        WHERE 1=1";

if ($statusFilter !== 'all') {
    $sql .= " AND bt.status = ?";
}
$sql .= " ORDER BY bt.created_at DESC";

$stmt = $pdo->prepare($sql);
if ($statusFilter !== 'all') {
    $stmt->execute([$statusFilter]);
} else {
    $stmt->execute();
}
$transfers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ספירה לפי סטטוס
$counts = $pdo->query("SELECT status, COUNT(*) as cnt FROM bank_transfers GROUP BY status")->fetchAll(PDO::FETCH_KEY_PAIR);
$pendingCount = $counts['pending'] ?? 0;
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>העברות בנקאיות</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, sans-serif; background: #f0f2f5; min-height: 100vh; }
        
        .header {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header h1 { font-size: 1.5rem; }
        .header a { color: white; text-decoration: none; }
        
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        
        .tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }
        .tab {
            padding: 10px 20px;
            background: white;
            border-radius: 8px;
            text-decoration: none;
            color: #333;
            font-weight: 500;
        }
        .tab.active {
            background: #667eea;
            color: white;
        }
        .tab .badge {
            background: #dc3545;
            color: white;
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 0.8rem;
            margin-right: 5px;
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .alert.success { background: #d4edda; color: #155724; }
        .alert.warning { background: #fff3cd; color: #856404; }
        
        .transfers-grid {
            display: grid;
            gap: 20px;
        }
        
        .transfer-card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            overflow: hidden;
        }
        .transfer-header {
            background: #f8f9fa;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid #eee;
        }
        .transfer-header h3 { font-size: 1.1rem; }
        .transfer-body {
            padding: 20px;
            display: grid;
            grid-template-columns: 1fr 200px;
            gap: 20px;
        }
        .transfer-details {}
        .transfer-row {
            display: flex;
            padding: 8px 0;
            border-bottom: 1px solid #f0f0f0;
        }
        .transfer-row:last-child { border-bottom: none; }
        .transfer-label { width: 120px; color: #666; }
        .transfer-value { font-weight: 500; }
        
        .screenshot-preview {
            text-align: center;
        }
        .screenshot-preview img {
            max-width: 100%;
            max-height: 250px;
            border-radius: 8px;
            border: 2px solid #ddd;
            cursor: pointer;
        }
        
        .transfer-actions {
            padding: 15px 20px;
            background: #f8f9fa;
            border-top: 1px solid #eee;
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 0.95rem;
            font-weight: 500;
        }
        .btn-approve { background: #28a745; color: white; }
        .btn-reject { background: #dc3545; color: white; }
        .btn-view { background: #667eea; color: white; }
        
        .status-badge {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
        }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-approved { background: #d4edda; color: #155724; }
        .status-rejected { background: #f8d7da; color: #721c24; }
        
        .amount-big {
            font-size: 1.5rem;
            font-weight: bold;
            color: #28a745;
        }
        
        .empty-state {
            text-align: center;
            padding: 50px;
            color: #666;
        }
        
        /* מודאל לתמונה גדולה */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.9);
            z-index: 1000;
            justify-content: center;
            align-items: center;
        }
        .modal.active { display: flex; }
        .modal img {
            max-width: 95%;
            max-height: 95%;
        }
        .modal-close {
            position: absolute;
            top: 20px;
            left: 20px;
            color: white;
            font-size: 2rem;
            cursor: pointer;
        }
        
        .reject-form {
            display: none;
            margin-top: 10px;
        }
        .reject-form.show { display: block; }
        .reject-form input {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 6px;
            width: 200px;
            margin-left: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>🏦 העברות בנקאיות</h1>
        <a href="index.php">← חזרה לדף הבית</a>
    </div>
    
    <div class="container">
        <?= $message ?>
        
        <div class="tabs">
            <a href="?status=pending" class="tab <?= $statusFilter === 'pending' ? 'active' : '' ?>">
                ⏳ ממתינות
                <?php if ($pendingCount > 0): ?>
                <span class="badge"><?= $pendingCount ?></span>
                <?php endif; ?>
            </a>
            <a href="?status=approved" class="tab <?= $statusFilter === 'approved' ? 'active' : '' ?>">✅ מאושרות</a>
            <a href="?status=rejected" class="tab <?= $statusFilter === 'rejected' ? 'active' : '' ?>">❌ נדחו</a>
            <a href="?status=all" class="tab <?= $statusFilter === 'all' ? 'active' : '' ?>">📋 הכל</a>
        </div>
        
        <?php if (empty($transfers)): ?>
        <div class="empty-state">
            <h2>🎉 אין העברות <?= $statusFilter === 'pending' ? 'ממתינות' : '' ?></h2>
            <p>כל ההעברות טופלו!</p>
        </div>
        <?php else: ?>
        
        <div class="transfers-grid">
            <?php foreach ($transfers as $t): ?>
            <div class="transfer-card">
                <div class="transfer-header">
                    <div>
                        <h3>
                            <?= htmlspecialchars($t['transferrer_name']) ?>
                            <span class="amount-big">₪<?= number_format($t['amount']) ?></span>
                        </h3>
                        <small style="color:#666;">
                            <?= date('d/m/Y H:i', strtotime($t['created_at'])) ?>
                            <?php if ($t['draft_customer']): ?>
                            • <?= htmlspecialchars($t['draft_customer']) ?>
                            <?php if ($t['destination']): ?>
                            → <?= htmlspecialchars($t['destination']) ?>
                            <?php endif; ?>
                            <?php endif; ?>
                        </small>
                    </div>
                    <span class="status-badge status-<?= $t['status'] ?>">
                        <?= $t['status'] === 'pending' ? '⏳ ממתין' : ($t['status'] === 'approved' ? '✅ מאושר' : '❌ נדחה') ?>
                    </span>
                </div>
                
                <div class="transfer-body">
                    <div class="transfer-details">
                        <div class="transfer-row">
                            <span class="transfer-label">שם המעביר:</span>
                            <span class="transfer-value"><?= htmlspecialchars($t['transferrer_name']) ?></span>
                        </div>
                        <?php if ($t['transferrer_phone']): ?>
                        <div class="transfer-row">
                            <span class="transfer-label">טלפון:</span>
                            <span class="transfer-value"><?= htmlspecialchars($t['transferrer_phone']) ?></span>
                        </div>
                        <?php endif; ?>
                        <div class="transfer-row">
                            <span class="transfer-label">תאריך העברה:</span>
                            <span class="transfer-value"><?= date('d/m/Y', strtotime($t['transfer_date'])) ?></span>
                        </div>
                        <?php if ($t['reference_number']): ?>
                        <div class="transfer-row">
                            <span class="transfer-label">מס' אסמכתא:</span>
                            <span class="transfer-value"><?= htmlspecialchars($t['reference_number']) ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if ($t['notes']): ?>
                        <div class="transfer-row">
                            <span class="transfer-label">הערות:</span>
                            <span class="transfer-value"><?= htmlspecialchars($t['notes']) ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if ($t['total_price']): ?>
                        <div class="transfer-row">
                            <span class="transfer-label">סה"כ להזמנה:</span>
                            <span class="transfer-value">₪<?= number_format($t['total_price']) ?></span>
                        </div>
                        <div class="transfer-row">
                            <span class="transfer-label">שולם עד כה:</span>
                            <span class="transfer-value">₪<?= number_format($t['amount_paid'] ?? 0) ?></span>
                        </div>
                        <?php endif; ?>
                        <?php if ($t['status'] !== 'pending' && $t['reviewer_name']): ?>
                        <div class="transfer-row">
                            <span class="transfer-label">נבדק ע"י:</span>
                            <span class="transfer-value"><?= htmlspecialchars($t['reviewer_name']) ?> (<?= date('d/m H:i', strtotime($t['reviewed_at'])) ?>)</span>
                        </div>
                        <?php endif; ?>
                        <?php if ($t['rejection_reason']): ?>
                        <div class="transfer-row">
                            <span class="transfer-label">סיבת דחייה:</span>
                            <span class="transfer-value" style="color:#dc3545;"><?= htmlspecialchars($t['rejection_reason']) ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="screenshot-preview">
                        <?php if ($t['screenshot_path']): ?>
                        <img src="<?= htmlspecialchars($t['screenshot_path']) ?>" alt="צילום מסך" onclick="showImage(this.src)">
                        <br><small>לחץ להגדלה</small>
                        <?php else: ?>
                        <p style="color:#999;">אין צילום מסך</p>
                        <?php endif; ?>
                    </div>
                </div>
                
                <?php if ($t['status'] === 'pending'): ?>
                <div class="transfer-actions">
                    <form method="POST" style="display:inline;">
                        <input type="hidden" name="transfer_id" value="<?= $t['id'] ?>">
                        <input type="hidden" name="action" value="approve">
                        <button type="submit" class="btn btn-approve" onclick="return confirm('לאשר העברה של ₪<?= number_format($t['amount']) ?>?')">
                            ✅ אשר העברה
                        </button>
                    </form>
                    
                    <button type="button" class="btn btn-reject" onclick="showRejectForm(<?= $t['id'] ?>)">
                        ❌ דחה
                    </button>
                    
                    <form method="POST" id="rejectForm<?= $t['id'] ?>" class="reject-form">
                        <input type="hidden" name="transfer_id" value="<?= $t['id'] ?>">
                        <input type="hidden" name="action" value="reject">
                        <input type="text" name="rejection_reason" placeholder="סיבת דחייה (אופציונלי)">
                        <button type="submit" class="btn btn-reject">אשר דחייה</button>
                    </form>
                    
                    <?php if ($t['draft_id']): ?>
                    <a href="drafts_list.php" class="btn btn-view">👁️ צפה בטיוטה</a>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- מודאל לתמונה גדולה -->
    <div class="modal" id="imageModal" onclick="hideImage()">
        <span class="modal-close">&times;</span>
        <img id="modalImage" src="">
    </div>
    
    <script>
        function showImage(src) {
            document.getElementById('modalImage').src = src;
            document.getElementById('imageModal').classList.add('active');
        }
        
        function hideImage() {
            document.getElementById('imageModal').classList.remove('active');
        }
        
        function showRejectForm(id) {
            document.getElementById('rejectForm' + id).classList.toggle('show');
        }
        
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') hideImage();
        });
    </script>
</body>
</html>
