<?php
// עיבוד תשלום - Cardcom API v11 (JSON) - תמיכה בתשלומים חלקיים
require_once 'includes/config.php';

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$token = $_POST['token'] ?? '';
$paymentType = $_POST['payment_type'] ?? 'full';
$customAmount = $_POST['custom_amount'] ?? 0;
$maxAmount = $_POST['max_amount'] ?? 0;
$payerName = $_POST['payer_name'] ?? '';
$payerEmail = $_POST['payer_email'] ?? '';

if (!$token) {
    die('Token missing');
}

// שליפת הטיוטה
$stmt = $pdo->prepare("SELECT * FROM drafts WHERE token = ? AND status NOT IN ('cancelled', 'expired')");
$stmt->execute([$token]);
$draft = $stmt->fetch();

if (!$draft) {
    die('Draft not found');
}

// חישוב סכום לתשלום
$totalPrice = floatval($draft['total_price']);
$amountPaid = floatval($draft['amount_paid'] ?? 0);
$remaining = $totalPrice - $amountPaid;

// קביעת סכום התשלום לפי בחירת הלקוח
if ($paymentType === 'full') {
    $amountToCharge = $remaining;
} elseif ($paymentType === 'per_person') {
    $amountToCharge = floatval($draft['price_per_person']);
} elseif ($paymentType === 'custom') {
    $amountToCharge = floatval($customAmount);
} else {
    $amountToCharge = $remaining;
}

// וידוא שהסכום לא גדול מהיתרה
if ($amountToCharge > $remaining) {
    $amountToCharge = $remaining;
}

// וידוא שהסכום חיובי
if ($amountToCharge <= 0) {
    die('Invalid amount');
}

// שמירת פרטי המשלם בטבלה זמנית (לפני שעוברים ל-Cardcom)
try {
    $pdo->exec("CREATE TABLE IF NOT EXISTS pending_payments (
        id INT AUTO_INCREMENT PRIMARY KEY,
        token VARCHAR(100) NOT NULL,
        payer_name VARCHAR(255),
        payer_email VARCHAR(255),
        amount DECIMAL(10,2),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX(token)
    ) DEFAULT CHARSET=utf8mb4");
    
    // מחיקת רשומות ישנות לאותו token
    $pdo->prepare("DELETE FROM pending_payments WHERE token = ?")->execute([$token]);
    
    // שמירת הפרטים החדשים
    $pdo->prepare("INSERT INTO pending_payments (token, payer_name, payer_email, amount) VALUES (?, ?, ?, ?)")
        ->execute([$token, $payerName, $payerEmail, $amountToCharge]);
} catch (Exception $e) {
    // לא קריטי - ממשיכים
}

// שליפת הגדרות Cardcom
$cardcom = $pdo->query("SELECT * FROM cardcom_settings WHERE id = 1")->fetch();

// הכנת URLs
$baseUrl = 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']);
$successUrl = $baseUrl . '/payment_success.php?token=' . $token;
$failureUrl = $baseUrl . '/payment_failed.php?token=' . $token;
$webhookUrl = $baseUrl . '/cardcom_callback.php';

// בדיקה אם במצב טסט
$isTestMode = ($cardcom['is_test_mode'] ?? 1) == 1;

if ($isTestMode) {
    // פרטי טסט אמיתיים מהסוואגר של Cardcom
    $terminalNumber = 1000;
    $apiName = "CardTest1994";
    $apiPassword = "Terminaltest2026";
} else {
    // פרטים אמיתיים
    $terminalNumber = intval($cardcom['terminal_number']);
    $apiName = $cardcom['api_name'];
    $apiPassword = $cardcom['api_password'];
}

// בניית הבקשה בפורמט JSON - API v11
$requestData = [
    'TerminalNumber' => $terminalNumber,
    'ApiName' => $apiName,
    'ApiPassword' => $apiPassword,
    'Amount' => $amountToCharge,
    'SuccessRedirectUrl' => $successUrl,
    'FailedRedirectUrl' => $failureUrl,
    'WebHookUrl' => $webhookUrl,
    'ReturnValue' => $token . '|' . $amountToCharge, // רק token וסכום - שאר הפרטים בטבלה
    'CreateInvoice' => false, // לא ליצור חשבונית ב-Cardcom
    'Document' => [
        'To' => $payerName ?: $draft['customer_name'],
        'Products' => [
            [
                'Description' => 'Holiday Package - ' . $draft['destination'] . ($remaining > $amountToCharge ? ' (תשלום חלקי)' : ''),
                'UnitCost' => $amountToCharge
            ]
        ]
    ]
];

// לוג
$logDir = __DIR__ . '/logs';
if (!is_dir($logDir)) mkdir($logDir, 0755, true);

// שליחת הבקשה - API v11 JSON
$apiUrl = 'https://secure.cardcom.solutions/api/v11/LowProfile/Create';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

// לוג (הסתר סיסמה)
$logRequest = $requestData;
$logRequest['ApiPassword'] = '***HIDDEN***';
$logData = date('Y-m-d H:i:s') . " | Token: $token | Amount: $amountToCharge | Payer: $payerName | Email: $payerEmail | TestMode: " . ($isTestMode ? 'YES' : 'NO') . "\n";
$logData .= "URL: $apiUrl\n";
$logData .= "Request: " . json_encode($logRequest, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
$logData .= "HTTP Code: $httpCode\n";
$logData .= "Response: $response\n";
$logData .= "Error: $error\n---\n";
file_put_contents($logDir . '/cardcom_' . date('Y-m-d') . '.log', $logData, FILE_APPEND);

if ($error) {
    die("CURL Error: $error");
}

// פענוח תשובה JSON
$result = json_decode($response, true);

// בדיקה אם יש URL לדף התשלום
if (!empty($result['Url'])) {
    header('Location: ' . $result['Url']);
    exit;
}

// בדיקה אם יש LowProfileId
if (!empty($result['LowProfileId'])) {
    $payUrl = 'https://secure.cardcom.solutions/External/LowProfileClearing.aspx?LowProfileCode=' . $result['LowProfileId'];
    header('Location: ' . $payUrl);
    exit;
}

// שגיאה - הצג פרטים מלאים
$displayRequest = $requestData;
$displayRequest['ApiPassword'] = '***HIDDEN***';
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>שגיאה</title>
    <style>
        body { font-family: Arial; padding: 40px; background: #f5f5f5; }
        .box { background: white; padding: 30px; border-radius: 10px; max-width: 700px; margin: 0 auto; }
        h1 { color: #dc3545; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; font-size: 12px; direction: ltr; text-align: left; white-space: pre-wrap; }
        a { color: #667eea; }
        .test-mode { background: #fff3cd; padding: 10px; border-radius: 5px; margin-bottom: 20px; }
    </style>
</head>
<body>
<div class="box">
    <h1>❌ שגיאה מ-Cardcom</h1>
    
    <?php if ($isTestMode): ?>
    <div class="test-mode">⚠️ מצב טסט - משתמש בפרטי הדמו של Cardcom</div>
    <?php endif; ?>
    
    <h3>HTTP Code:</h3>
    <pre><?= $httpCode ?></pre>
    
    <h3>Response Code:</h3>
    <pre><?= htmlspecialchars($result['ResponseCode'] ?? 'N/A') ?></pre>
    
    <h3>Description:</h3>
    <pre><?= htmlspecialchars($result['Description'] ?? 'N/A') ?></pre>
    
    <h3>Full Response:</h3>
    <pre><?= htmlspecialchars(json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) ?></pre>
    
    <h3>Sent Data:</h3>
    <pre><?= htmlspecialchars(json_encode($displayRequest, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) ?></pre>
    
    <p><a href="pay.php?token=<?= htmlspecialchars($token) ?>">← חזרה</a></p>
</div>
</body>
</html>
<?php