<?php
// דוחות מהירים
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();

// בחירת דוח
$report = $_GET['report'] ?? '';
$month = $_GET['month'] ?? date('Y-m');
$airline = $_GET['airline'] ?? '';
$supplier = $_GET['supplier'] ?? '';

$results = [];
$title = '';

switch ($report) {
    case 'by_date_airline':
        $title = '📅 הזמנות ממוינות לפי תאריך + חברת תעופה';
        $results = $pdo->query("
            SELECT id, order_date, destination, departure_date, return_date, 
                   airline_outbound, flight_supplier, customer_phone,
                   (SELECT GROUP_CONCAT(name SEPARATOR ', ') FROM JSON_TABLE(passengers, '\$[*]' COLUMNS (name VARCHAR(100) PATH '\$')) as jt) as passenger_names
            FROM orders 
            ORDER BY departure_date DESC, airline_outbound
            LIMIT 100
        ")->fetchAll();
        break;
        
    case 'airline_month':
        if ($airline && $month) {
            $startDate = $month . '-01';
            $endDate = date('Y-m-t', strtotime($startDate));
            $title = "✈️ כל הטיסות עם $airline ב-" . date('m/Y', strtotime($startDate));
            $stmt = $pdo->prepare("
                SELECT id, order_date, destination, departure_date, return_date,
                       airline_outbound, airline_return, flight_supplier, customer_phone,
                       flight_supplier_cost, flight_supplier_currency
                FROM orders 
                WHERE (airline_outbound = ? OR airline_return = ?)
                AND departure_date BETWEEN ? AND ?
                ORDER BY departure_date
            ");
            $stmt->execute([$airline, $airline, $startDate, $endDate]);
            $results = $stmt->fetchAll();
        }
        break;
        
    case 'by_supplier':
        if ($supplier) {
            $title = "💰 כל ההזמנות דרך $supplier";
            $stmt = $pdo->prepare("
                SELECT id, order_date, destination, departure_date, return_date,
                       airline_outbound, flight_supplier, customer_phone,
                       flight_supplier_cost, flight_supplier_currency, flight_supplier_paid
                FROM orders 
                WHERE flight_supplier = ? OR return_flight_supplier = ?
                ORDER BY departure_date DESC
                LIMIT 100
            ");
            $stmt->execute([$supplier, $supplier]);
            $results = $stmt->fetchAll();
        }
        break;
        
    case 'unpaid_suppliers':
        $title = '⏳ הזמנות שטרם שולם לספק';
        $results = $pdo->query("
            SELECT id, order_date, destination, departure_date,
                   flight_supplier, flight_supplier_cost, flight_supplier_currency,
                   airline_outbound, customer_phone
            FROM orders 
            WHERE flight_supplier_paid = 'unpaid' AND flight_supplier != 'DIRECT' AND flight_supplier != ''
            ORDER BY departure_date
        ")->fetchAll();
        break;
        
    case 'this_month':
        $startDate = date('Y-m-01');
        $endDate = date('Y-m-t');
        $title = '📆 כל ההזמנות החודש (' . date('m/Y') . ')';
        $stmt = $pdo->prepare("
            SELECT id, order_date, destination, departure_date, return_date,
                   airline_outbound, flight_supplier, customer_phone
            FROM orders 
            WHERE departure_date BETWEEN ? AND ?
            ORDER BY departure_date
        ");
        $stmt->execute([$startDate, $endDate]);
        $results = $stmt->fetchAll();
        break;
}

// שליפת רשימות לפילטרים
$airlines = $pdo->query("SELECT DISTINCT airline_outbound FROM orders WHERE airline_outbound IS NOT NULL AND airline_outbound != '' ORDER BY airline_outbound")->fetchAll(PDO::FETCH_COLUMN);
$suppliers = $pdo->query("SELECT DISTINCT flight_supplier FROM orders WHERE flight_supplier IS NOT NULL AND flight_supplier != '' AND flight_supplier != 'DIRECT' ORDER BY flight_supplier")->fetchAll(PDO::FETCH_COLUMN);
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>דוחות מהירים | <?= SITE_NAME ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, sans-serif; background: #1a1a2e; min-height: 100vh; padding: 20px; }
        .container { max-width: 1200px; margin: 0 auto; }
        h1 { color: white; margin-bottom: 20px; }
        .reports-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px; margin-bottom: 30px; }
        .report-card { background: white; padding: 20px; border-radius: 10px; text-decoration: none; color: #333; transition: transform 0.2s, box-shadow 0.2s; }
        .report-card:hover { transform: translateY(-3px); box-shadow: 0 5px 20px rgba(0,0,0,0.2); }
        .report-card h3 { font-size: 1rem; margin-bottom: 5px; }
        .report-card p { font-size: 0.85rem; color: #666; }
        .filter-form { background: white; padding: 20px; border-radius: 10px; margin-bottom: 20px; display: flex; gap: 15px; flex-wrap: wrap; align-items: end; }
        .filter-form label { display: block; font-size: 0.85rem; color: #666; margin-bottom: 5px; }
        .filter-form select, .filter-form input { padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 1rem; }
        .filter-form button { background: #667eea; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; }
        .results { background: white; border-radius: 10px; overflow: hidden; }
        .results-header { background: #667eea; color: white; padding: 15px 20px; }
        .results-header h2 { font-size: 1.1rem; }
        .results-count { font-size: 0.9rem; opacity: 0.8; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px 15px; text-align: right; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; font-weight: 600; }
        tr:hover { background: #f8f9fa; }
        .badge { padding: 3px 8px; border-radius: 12px; font-size: 0.8rem; }
        .badge-paid { background: #d4edda; color: #155724; }
        .badge-unpaid { background: #fff3cd; color: #856404; }
        .back-link { color: white; text-decoration: none; display: inline-block; margin-bottom: 15px; }
        .empty { padding: 40px; text-align: center; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <a href="orders_new.php" class="back-link">← חזרה לניהול הזמנות</a>
        <h1>📊 דוחות מהירים</h1>
        
        <!-- כרטיסי דוחות -->
        <div class="reports-grid">
            <a href="?report=by_date_airline" class="report-card">
                <h3>📅 לפי תאריך + חברת תעופה</h3>
                <p>כל ההזמנות ממוינות לפי תאריך טיסה וחברה</p>
            </a>
            <a href="?report=this_month" class="report-card">
                <h3>📆 הזמנות החודש</h3>
                <p>כל הטיסות שיוצאות החודש</p>
            </a>
            <a href="?report=unpaid_suppliers" class="report-card">
                <h3>⏳ טרם שולם לספקים</h3>
                <p>הזמנות שלא שולמו לספקים</p>
            </a>
        </div>
        
        <!-- פילטרים מתקדמים -->
        <div class="filter-form">
            <div>
                <label>חברת תעופה</label>
                <select name="airline" id="airline">
                    <option value="">בחר חברה</option>
                    <?php foreach ($airlines as $a): ?>
                        <option value="<?= htmlspecialchars($a) ?>" <?= $airline == $a ? 'selected' : '' ?>><?= htmlspecialchars($a) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label>חודש</label>
                <input type="month" name="month" id="month" value="<?= $month ?>">
            </div>
            <button onclick="window.location='?report=airline_month&airline='+document.getElementById('airline').value+'&month='+document.getElementById('month').value">
                🔍 חפש לפי חברה + חודש
            </button>
        </div>
        
        <div class="filter-form">
            <div>
                <label>ספק</label>
                <select name="supplier" id="supplier">
                    <option value="">בחר ספק</option>
                    <?php foreach ($suppliers as $s): ?>
                        <option value="<?= htmlspecialchars($s) ?>" <?= $supplier == $s ? 'selected' : '' ?>><?= htmlspecialchars($s) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button onclick="window.location='?report=by_supplier&supplier='+document.getElementById('supplier').value">
                🔍 חפש לפי ספק
            </button>
        </div>
        
        <!-- תוצאות -->
        <?php if ($report && $title): ?>
        <div class="results">
            <div class="results-header">
                <h2><?= $title ?></h2>
                <div class="results-count"><?= count($results) ?> תוצאות</div>
            </div>
            
            <?php if (empty($results)): ?>
                <div class="empty">😕 לא נמצאו תוצאות</div>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>יעד</th>
                            <th>תאריך הלוך</th>
                            <th>תאריך חזור</th>
                            <th>חברת תעופה</th>
                            <th>ספק</th>
                            <th>עלות</th>
                            <th>טלפון</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($results as $row): ?>
                        <tr>
                            <td><a href="view_order.php?id=<?= $row['id'] ?>"><?= $row['id'] ?></a></td>
                            <td><?= htmlspecialchars($row['destination'] ?? '-') ?></td>
                            <td><?= $row['departure_date'] ?? '-' ?></td>
                            <td><?= $row['return_date'] ?? '-' ?></td>
                            <td><?= htmlspecialchars($row['airline_outbound'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($row['flight_supplier'] ?? '-') ?></td>
                            <td>
                                <?php if (!empty($row['flight_supplier_cost'])): ?>
                                    <?= number_format($row['flight_supplier_cost'], 2) ?> <?= $row['flight_supplier_currency'] ?? '' ?>
                                    <?php if (isset($row['flight_supplier_paid'])): ?>
                                        <span class="badge <?= $row['flight_supplier_paid'] == 'paid' ? 'badge-paid' : 'badge-unpaid' ?>">
                                            <?= $row['flight_supplier_paid'] == 'paid' ? 'שולם' : 'טרם' ?>
                                        </span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td><?= htmlspecialchars($row['customer_phone'] ?? '-') ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
