<?php
require_once 'includes/config.php';

$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_reset'])) {
    if ($_POST['confirm_reset'] === 'אני מאשר מחיקה') {
        try {
            $pdo = getDB();
            
            // מחיקת כל הנתונים
            $pdo->exec("DELETE FROM order_items");
            $pdo->exec("DELETE FROM draft_payments");
            $pdo->exec("DELETE FROM drafts");
            $pdo->exec("DELETE FROM orders");
            
            // איפוס מספור
            $pdo->exec("ALTER TABLE order_items AUTO_INCREMENT = 1");
            $pdo->exec("ALTER TABLE draft_payments AUTO_INCREMENT = 1");
            $pdo->exec("ALTER TABLE drafts AUTO_INCREMENT = 1");
            $pdo->exec("ALTER TABLE orders AUTO_INCREMENT = 1");
            
            $message = '✅ כל הנתונים נמחקו והמספור אופס!';
            $messageType = 'success';
        } catch (Exception $e) {
            $message = '❌ שגיאה: ' . $e->getMessage();
            $messageType = 'error';
        }
    } else {
        $message = '⚠️ לא הקלדת את טקסט האישור הנכון';
        $messageType = 'warning';
    }
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="he">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>איפוס נתונים</title>
    <style>
        * { box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            background: white;
            border-radius: 20px;
            padding: 40px;
            max-width: 500px;
            width: 100%;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 {
            color: #e74c3c;
            text-align: center;
            margin-bottom: 10px;
        }
        .warning-icon {
            font-size: 60px;
            text-align: center;
            display: block;
            margin-bottom: 20px;
        }
        .warning-text {
            background: #fff3cd;
            border: 1px solid #ffc107;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            color: #856404;
        }
        .warning-text ul {
            margin: 10px 0 0 0;
            padding-right: 20px;
        }
        input[type="text"] {
            width: 100%;
            padding: 15px;
            border: 2px solid #ddd;
            border-radius: 10px;
            font-size: 16px;
            text-align: center;
            margin-bottom: 15px;
        }
        input[type="text"]:focus {
            border-color: #e74c3c;
            outline: none;
        }
        .btn-reset {
            width: 100%;
            padding: 15px;
            background: #e74c3c;
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
        }
        .btn-reset:hover {
            background: #c0392b;
            transform: scale(1.02);
        }
        .btn-back {
            display: block;
            text-align: center;
            margin-top: 20px;
            color: #667;
            text-decoration: none;
        }
        .btn-back:hover {
            color: #333;
        }
        .message {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
            font-weight: bold;
        }
        .message.success { background: #d4edda; color: #155724; }
        .message.error { background: #f8d7da; color: #721c24; }
        .message.warning { background: #fff3cd; color: #856404; }
        .confirm-text {
            text-align: center;
            color: #666;
            margin-bottom: 10px;
        }
        code {
            background: #f4f4f4;
            padding: 2px 8px;
            border-radius: 4px;
            color: #e74c3c;
        }
    </style>
</head>
<body>
    <div class="container">
        <span class="warning-icon">⚠️</span>
        <h1>איפוס כל הנתונים</h1>
        
        <?php if ($message): ?>
            <div class="message <?= $messageType ?>"><?= $message ?></div>
        <?php endif; ?>
        
        <div class="warning-text">
            <strong>שים לב! פעולה זו תמחק:</strong>
            <ul>
                <li>כל ההזמנות</li>
                <li>כל הטיוטות</li>
                <li>כל התשלומים</li>
                <li>איפוס מספור מ-1</li>
            </ul>
            <strong>אין דרך לשחזר!</strong>
        </div>
        
        <form method="POST">
            <p class="confirm-text">הקלד <code>אני מאשר מחיקה</code> לאישור:</p>
            <input type="text" name="confirm_reset" placeholder="הקלד כאן..." autocomplete="off">
            <button type="submit" class="btn-reset">🗑️ מחק הכל ואפס</button>
        </form>
        
        <a href="drafts_list.php" class="btn-back">← חזרה לרשימת טיוטות</a>
    </div>
</body>
</html>
