<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();

// Only run if confirmed
$confirmed = isset($_GET['confirm']) && $_GET['confirm'] === 'yes';

if (!$confirmed) {
    echo "<!DOCTYPE html>
<html dir='rtl'>
<head>
    <meta charset='utf-8'>
    <title>Reset Orders</title>
    <style>
        body { font-family: Arial; padding: 50px; background: #f5f5f5; }
        .box { background: white; padding: 40px; border-radius: 15px; max-width: 500px; margin: 0 auto; text-align: center; box-shadow: 0 5px 20px rgba(0,0,0,0.1); }
        h1 { color: #dc3545; }
        p { color: #666; font-size: 18px; margin: 20px 0; }
        .warning { background: #fff3cd; padding: 15px; border-radius: 8px; margin: 20px 0; }
        .btn { display: inline-block; padding: 15px 40px; margin: 10px; border-radius: 8px; text-decoration: none; font-size: 16px; font-weight: bold; }
        .btn-danger { background: #dc3545; color: white; }
        .btn-secondary { background: #6c757d; color: white; }
    </style>
</head>
<body>
    <div class='box'>
        <h1>⚠️ מחיקת כל ההזמנות</h1>
        <p>פעולה זו תמחק את כל ההזמנות במערכת ותאפס את המונה ל-1</p>
        <div class='warning'>
            <strong>שים לב!</strong><br>
            פעולה זו בלתי הפיכה!
        </div>
        <a href='reset_orders.php?confirm=yes' class='btn btn-danger'>🗑️ כן, מחק הכל</a>
        <a href='orders_new.php' class='btn btn-secondary'>ביטול</a>
    </div>
</body>
</html>";
    exit;
}

try {
    // Delete all orders
    $pdo->exec("DELETE FROM orders");
    
    // Reset auto increment to 1
    $pdo->exec("ALTER TABLE orders AUTO_INCREMENT = 1");
    
    echo "<!DOCTYPE html>
<html dir='rtl'>
<head>
    <meta charset='utf-8'>
    <title>Reset Complete</title>
    <style>
        body { font-family: Arial; padding: 50px; background: #f5f5f5; }
        .box { background: white; padding: 40px; border-radius: 15px; max-width: 500px; margin: 0 auto; text-align: center; box-shadow: 0 5px 20px rgba(0,0,0,0.1); }
        h1 { color: #28a745; }
        p { color: #666; font-size: 18px; }
        .btn { display: inline-block; padding: 15px 40px; margin-top: 20px; border-radius: 8px; text-decoration: none; font-size: 16px; background: #667eea; color: white; }
    </style>
</head>
<body>
    <div class='box'>
        <h1>✅ הושלם!</h1>
        <p>כל ההזמנות נמחקו</p>
        <p>ההזמנה הבאה תהיה מספר <strong>#1</strong></p>
        <a href='orders_new.php' class='btn'>להזמנות →</a>
    </div>
</body>
</html>";

} catch (Exception $e) {
    echo "<h1 style='color:red;'>Error!</h1>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>
