<?php
/**
 * Run migration to add Invoice4U receipt columns + amount_paid
 */
require_once 'includes/config.php';

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$results = [];

// Add receipt columns to orders table
$columns = [
    ['orders', 'receipt_number', "VARCHAR(50) NULL"],
    ['orders', 'receipt_url', "TEXT NULL"],
    ['orders', 'receipt_date', "DATETIME NULL"],
    ['drafts', 'receipt_number', "VARCHAR(50) NULL"],
    ['drafts', 'receipt_url', "TEXT NULL"],
    ['drafts', 'amount_paid', "DECIMAL(10,2) DEFAULT 0"],
    ['drafts', 'payment_installments', "INT DEFAULT 1"],
    ['drafts', 'payment_last4', "VARCHAR(4) NULL"],
    ['drafts', 'payment_card_brand', "VARCHAR(50) NULL"],
    ['drafts', 'payment_approval', "VARCHAR(50) NULL"],
];

foreach ($columns as $col) {
    $table = $col[0];
    $column = $col[1];
    $definition = $col[2];
    
    // Check if column exists
    $stmt = $pdo->prepare("SHOW COLUMNS FROM $table LIKE ?");
    $stmt->execute([$column]);
    
    if ($stmt->rowCount() == 0) {
        try {
            $pdo->exec("ALTER TABLE $table ADD COLUMN $column $definition");
            $results[] = "✅ Added $table.$column";
        } catch (Exception $e) {
            $results[] = "❌ Error adding $table.$column: " . $e->getMessage();
        }
    } else {
        $results[] = "⏭️ $table.$column already exists";
    }
}

// Create draft_payments table if not exists
try {
    $pdo->exec("CREATE TABLE IF NOT EXISTS draft_payments (
        id INT AUTO_INCREMENT PRIMARY KEY,
        draft_id INT NOT NULL,
        payer_name VARCHAR(255),
        amount DECIMAL(10,2) NOT NULL,
        transaction_id VARCHAR(100),
        payment_date DATETIME DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_draft_id (draft_id)
    )");
    $results[] = "✅ draft_payments table ready";
} catch (Exception $e) {
    $results[] = "⏭️ draft_payments: " . $e->getMessage();
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="he">
<head>
    <meta charset="UTF-8">
    <title>Migration - Invoice4U Columns</title>
    <style>
        body { font-family: Arial; padding: 40px; background: #f5f5f5; }
        .box { background: white; padding: 30px; border-radius: 10px; max-width: 600px; margin: 0 auto; }
        h1 { color: #333; }
        .result { padding: 10px; margin: 5px 0; background: #f8f9fa; border-radius: 5px; }
    </style>
</head>
<body>
<div class="box">
    <h1>🔧 Migration - Invoice4U Receipt Columns</h1>
    
    <?php foreach ($results as $result): ?>
    <div class="result"><?= $result ?></div>
    <?php endforeach; ?>
    
    <hr>
    <p><strong>Done!</strong> You can now use Invoice4U integration.</p>
    <p><a href="test_invoice4u.php">← Test Invoice4U</a></p>
</div>
</body>
</html>