<?php
// עריכה ושליחת אישור הזמנה
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();

$orderId = $_GET['id'] ?? null;
if (!$orderId) {
    header('Location: orders.php');
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
$stmt->execute([$orderId]);
$order = $stmt->fetch();

if (!$order) {
    header('Location: orders.php');
    exit;
}

$passengers = json_decode($order['passengers'] ?? '[]', true);

// חיפוש קבצי וואוצ'ר
$voucherFiles = [];
$uploadBasePath = 'uploads/vouchers/';
$orderDate = $order['order_date'] ?? $order['created_at'] ?? date('Y-m-d');
$yearMonth = date('Y/m/', strtotime($orderDate));

// נסה למצוא קובץ JSON
$possiblePaths = [
    $uploadBasePath . $yearMonth . 'order_' . $orderId . '_files.json',
    $uploadBasePath . date('Y/m/') . 'order_' . $orderId . '_files.json',
];

foreach ($possiblePaths as $path) {
    if (file_exists($path)) {
        $data = json_decode(file_get_contents($path), true);
        if ($data && !empty($data['files'])) {
            $voucherFiles = $data['files'];
        }
        break;
    }
}

// יצירת הטקסט - מהדאטאבייס אם קיים, אחרת ייצור חדש
$emailText = $order['email_text'] ?? '';

if (empty($emailText)) {
    // אין טקסט שמור - ניצור מחדש (עבור הזמנות ישנות)
    $destination = $order['destination'] ?? '';
    $departureDate = $order['departure_date'] ?? '';
    $returnDate = $order['return_date'] ?? '';
    $airline = $order['airline_outbound'] ?? '';
    $airlineReturn = $order['airline_return'] ?? '';
    $luggage = $order['luggage_details'] ?? '';

    // המרת יעד לעברית (אם יש)
    $hebrewDestinations = [
        'Budapest' => 'בודפשט',
        'Prague' => 'פראג',
        'Barcelona' => 'ברצלונה',
        'Rome' => 'רומא',
        'Paris' => 'פריז',
        'Athens' => 'אתונה',
        'Vienna' => 'וינה',
        'Amsterdam' => 'אמסטרדם',
        'Krakow' => 'קרקוב',
        'Lisbon' => 'ליסבון',
        'London' => 'לונדון',
        'Milan' => 'מילאנו',
        'Larnaca' => 'לרנקה',
        'Cyprus' => 'קפריסין',
        'Rhodes' => 'רודוס',
        'Heraklion' => 'הרקליון',
        'Crete' => 'כרתים',
    ];

    $hebrewDest = $destination;
    foreach ($hebrewDestinations as $eng => $heb) {
        if (stripos($destination, $eng) !== false) {
            $hebrewDest = $heb;
            break;
        }
    }

    // בדיקת סוג חברת תעופה
    $manualCheckinAirlines = ['wizzair', 'wizz air', 'wizz', 'ryanair', 'ryan air', 'flyone', 'fly one'];
    $airlineLower = strtolower($airline);
    $airlineReturnLower = strtolower($airlineReturn ?: $airline);
    
    $isOutboundManual = false;
    $isReturnManual = false;
    foreach ($manualCheckinAirlines as $a) {
        if (strpos($airlineLower, $a) !== false) $isOutboundManual = true;
        if (strpos($airlineReturnLower, $a) !== false) $isReturnManual = true;
    }
    
    $isDifferentReturn = !empty($airlineReturn) && $airlineReturn !== $airline;
    
    // טקסט חברת תעופה
    if ($isDifferentReturn) {
        $airlineText = "הטיסה בהלוך עם חברת {$airline}, בחזור עם חברת {$airlineReturn}. הטיסה בהלוך אמורה לצאת מטרמינל 3";
    } else {
        $airlineText = "הטיסות הן עם חברת {$airline}. הטיסה הלוך אמורה לצאת מטרמינל 3";
    }
    
    // טקסט כרטיסי טיסה
    if ($isOutboundManual && $isReturnManual) {
        $ticketsText = "כרטיסי טיסה תקבלו מאיתנו בוואטסאפ בטווח של 24 שעות מכל טיסה אחרי שנבצע לכם את הצ'ק אין.";
    } elseif (!$isOutboundManual && !$isReturnManual) {
        $ticketsText = "כרטיסי טיסה תקבלו בדלפק של חברת התעופה ביום הטיסה שם גם יבוצע לכם הצ'ק אין בחינם.";
    } elseif ($isOutboundManual) {
        $ticketsText = "בטיסת ההלוך - כרטיס הטיסה יישלח אליכם בוואטסאפ בטווח של 24 שעות מהטיסה אחרי שנבצע לכם את הצ'ק אין.\nבטיסת החזור - תקבלו את כרטיס הטיסה בדלפק של חברת התעופה ביום הטיסה שם גם יבוצע לכם הצ'ק אין בחינם.";
    } else {
        $ticketsText = "בטיסת ההלוך - תקבלו את כרטיס הטיסה בדלפק של חברת התעופה ביום הטיסה שם גם יבוצע לכם הצ'ק אין בחינם.\nבטיסת החזור - כרטיס הטיסה יישלח אליכם בוואטסאפ בטווח של 24 שעות מהטיסה אחרי שנבצע לכם את הצ'ק אין.";
    }
    
    // טקסט כבודה
    $luggageSection = '';
    if (!empty($luggage)) {
        $luggageSection = "\n\n🧳 כבודה\n{$luggage}";
    }
    
    // ביטוח ביטול (מעל 3 שבועות)
    $cancellationInsuranceText = '';
    if ($departureDate) {
        $diffDays = (strtotime($departureDate) - time()) / (60 * 60 * 24);
        if ($diffDays > 21) {
            $cancellationInsuranceText = "

━━━━━━━━━━━━━━━━━━━━━━━━━

🛡️ ביטוח ביטול נסיעה

במידה ומועד החופשה שלכם רחוק אנו ממליצים בחום לרכוש ביטוח לביטול מכל סיבה של חברת טריפ גרנטי (מבית הפניקס) שיאפשר לכם לקבל 80 אחוז בחזרה אפילו עד 6 שעות ממועד הטיסה.
ניתן לרכוש את הביטוח עד 7 ימים ממועד הזמנת החופשה ובתנאי שטווח הזמן עד הנסיעה גדול מ- 15 ימים. לפרטים מלאים ולרכישת הביטוח יש ללחוץ על הקישור הבא:
https://www.tripguaranty.co.il/InsurancePurchase/?agentCode=228";
        }
    }

    $emailText = "שלום רב,

מצורפים בזאת אישורי הזמנה של הטיסות והמלון ב{$hebrewDest}.
אנא וודאו שהשמות רשומים בדיוק כפי שהם מופיעים אצלכם בדרכון באנגלית.

━━━━━━━━━━━━━━━━━━━━━━━━━

✈️ הנחיות חשובות מאוד לטיסה

{$airlineText} אך יש לוודא זאת ביום הטיסה למקרה ויהיו שינויים בקישור הבא:
https://www.iaa.gov.il/airports/ben-gurion/flight-board/

יש להגיע לשדה לפחות 3 וחצי שעות לפני הטיסה.

{$ticketsText}{$luggageSection}{$cancellationInsuranceText}

━━━━━━━━━━━━━━━━━━━━━━━━━

🛡️ ביטוח נסיעות

טרם הנסיעה מומלץ מאוד לעשות ביטוח נסיעות לחו״ל שיכסה הוצאות רפואיות ומקרי חירום.
אנו ממליצים בחום על PassportCard, חברת ביטוח הנסיעות שלטעמנו היא המובילה והאמינה בישראל. ניתן לרכוש את הביטוח שלהם בקלות דרך הלינק הבא:
https://buy.passportcard.co.il/?AffiliateId=xEOn9OJj4ELo8mVndfdKjQ%3D%3D

יתרונות בולטים של PassportCard:
• אין הוצאות מהכיס בחו״ל - ללא צורך בהחזרים!
• מקבלים כרטיס פספורטכארד שמטעינים במקום ומאפשר לשלם ישר לרופא/בית חולים.
• שירות רופאים אונליין 24/7, כולל מרשמים דיגיטליים.
• שירות לקוחות זמין בוואטסאפ.
• מעקב ותפעול תביעה ישירות מהאפליקציה, ללא טפסים.
• אפשרות להרחבות כמו ביטול נסיעה, ציוד יקר, ספורט אתגרי ועוד.

━━━━━━━━━━━━━━━━━━━━━━━━━

למקרים דחופים נשמח לעמוד לרשותכם בוואטסאפ 050-6101031

מאחלים לכם חופשה נעימה! ✈️🌴";
}
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>שליחת אישור הזמנה #<?= $orderId ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, sans-serif;
            background: #f0f2f5;
            min-height: 100vh;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header h1 { font-size: 1.4rem; }
        .btn {
            padding: 10px 20px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            cursor: pointer;
            border: none;
            font-size: 0.95rem;
        }
        .btn-light { background: rgba(255,255,255,0.2); color: white; }
        .btn-success { background: #28a745; color: white; }
        .btn-primary { background: #667eea; color: white; }
        
        .container {
            max-width: 1000px;
            margin: 30px auto;
            padding: 0 20px;
        }
        
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            margin-bottom: 20px;
            overflow: hidden;
        }
        .card-header {
            padding: 15px 20px;
            border-bottom: 1px solid #eee;
            background: #f8f9fa;
        }
        .card-header h3 { font-size: 1rem; color: #333; }
        .card-body { padding: 20px; }
        
        .recipient-info {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
        }
        .recipient-info .field {
            flex: 1;
            min-width: 200px;
        }
        .recipient-info label {
            display: block;
            font-weight: 600;
            margin-bottom: 5px;
            color: #555;
        }
        .recipient-info input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 1rem;
        }
        
        textarea {
            width: 100%;
            min-height: 400px;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-family: inherit;
            font-size: 0.95rem;
            line-height: 1.6;
            resize: vertical;
        }
        
        .files-list {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        .file-item {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 12px 15px;
            background: #f8f9fa;
            border-radius: 8px;
        }
        .file-item .file-icon { font-size: 1.5rem; }
        .file-item .file-info { flex: 1; }
        .file-item .file-name { font-weight: 500; }
        .file-item .file-type { font-size: 0.85rem; color: #666; }
        .file-item .btn-remove {
            background: #dc3545;
            color: white;
            border: none;
            padding: 5px 12px;
            border-radius: 5px;
            cursor: pointer;
        }
        .file-item a {
            color: #667eea;
            text-decoration: none;
        }
        
        .add-file-area {
            border: 2px dashed #ddd;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 15px;
        }
        .add-file-area:hover {
            border-color: #667eea;
            background: #f8f9ff;
        }
        .add-file-area input { display: none; }
        
        .checkbox-row {
            display: flex;
            align-items: center;
            gap: 10px;
            margin: 10px 0;
        }
        .checkbox-row input[type="checkbox"] {
            width: 18px;
            height: 18px;
        }
        
        .send-section {
            text-align: center;
            padding: 30px;
        }
        .send-section .btn-success {
            font-size: 1.2rem;
            padding: 15px 40px;
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .alert-info {
            background: #e8f4fd;
            border: 1px solid #bee5eb;
            color: #0c5460;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>📧 שליחת אישור הזמנה #<?= $orderId ?></h1>
        <a href="view_order_new.php?id=<?= $orderId ?>" class="btn btn-light">← חזרה להזמנה</a>
    </div>
    
    <div class="container">
        <!-- נמען -->
        <div class="card">
            <div class="card-header">
                <h3>📬 פרטי נמען</h3>
            </div>
            <div class="card-body">
                <div class="recipient-info">
                    <div class="field">
                        <label>אימייל</label>
                        <input type="email" id="recipient_email" value="<?= htmlspecialchars($order['customer_email'] ?? '') ?>">
                    </div>
                    <div class="field">
                        <label>נושא המייל</label>
                        <input type="text" id="email_subject" value="אישור הזמנה - <?= htmlspecialchars($order['destination']) ?> - חופשה במבצע ✈️">
                    </div>
                </div>
            </div>
        </div>
        
        <!-- טקסט המייל -->
        <div class="card">
            <div class="card-header">
                <h3>📝 תוכן המייל</h3>
            </div>
            <div class="card-body">
                <textarea id="email_body"><?= htmlspecialchars($emailText) ?></textarea>
            </div>
        </div>
        
        <!-- קבצים מצורפים -->
        <div class="card">
            <div class="card-header">
                <h3>📎 קבצים מצורפים (<?= count($voucherFiles) ?>)</h3>
            </div>
            <div class="card-body">
                <div class="files-list" id="files-list">
                    <?php if (empty($voucherFiles)): ?>
                        <div class="alert alert-info">לא נמצאו קבצים מצורפים להזמנה זו</div>
                    <?php else: ?>
                        <?php foreach ($voucherFiles as $i => $file): ?>
                        <div class="file-item" data-path="<?= htmlspecialchars($file['path']) ?>">
                            <span class="file-icon">📄</span>
                            <div class="file-info">
                                <div class="file-name"><?= htmlspecialchars($file['label']) ?></div>
                                <div class="file-type"><?= basename($file['path']) ?></div>
                            </div>
                            <a href="<?= htmlspecialchars($file['path']) ?>" target="_blank" class="btn btn-light" style="background:#eee;color:#333;">👁️ צפה</a>
                            <button class="btn-remove" onclick="removeFile(this)">✕ הסר</button>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <div class="add-file-area" onclick="document.getElementById('new-file').click()">
                    <input type="file" id="new-file" multiple accept="image/*,.pdf" onchange="addFiles(this.files)">
                    <p>📎 לחץ להוספת קבצים נוספים</p>
                </div>
                
                <div class="checkbox-row">
                    <input type="checkbox" id="attach_terms" checked>
                    <label for="attach_terms">צרף תקנון (terms.pdf)</label>
                </div>
            </div>
        </div>
        
        <!-- כפתור שליחה -->
        <div class="card send-section">
            <button class="btn btn-success" onclick="sendEmail()">📧 שלח מייל ללקוח</button>
            <p style="margin-top: 15px; color: #666;">המייל יישלח ל: <strong id="email-display"><?= htmlspecialchars($order['customer_email'] ?? 'לא הוגדר') ?></strong></p>
        </div>
    </div>
    
    <script>
        // עדכון תצוגת מייל
        document.getElementById('recipient_email').addEventListener('input', function() {
            document.getElementById('email-display').textContent = this.value || 'לא הוגדר';
        });
        
        // הסרת קובץ
        function removeFile(btn) {
            btn.closest('.file-item').remove();
            updateFileCount();
        }
        
        // עדכון מונה קבצים
        function updateFileCount() {
            const count = document.querySelectorAll('.file-item').length;
            document.querySelector('.card-header h3').textContent = '📎 קבצים מצורפים (' + count + ')';
        }
        
        // הוספת קבצים חדשים
        const newFilesData = [];
        function addFiles(files) {
            const list = document.getElementById('files-list');
            const noFilesAlert = list.querySelector('.alert');
            if (noFilesAlert) noFilesAlert.remove();
            
            Array.from(files).forEach((file, i) => {
                const reader = new FileReader();
                reader.onload = function(e) {
                    newFilesData.push({
                        name: file.name,
                        data: e.target.result
                    });
                    
                    const div = document.createElement('div');
                    div.className = 'file-item';
                    div.dataset.newFile = newFilesData.length - 1;
                    div.innerHTML = `
                        <span class="file-icon">📄</span>
                        <div class="file-info">
                            <div class="file-name">${file.name}</div>
                            <div class="file-type">קובץ חדש</div>
                        </div>
                        <button class="btn-remove" onclick="removeFile(this)">✕ הסר</button>
                    `;
                    list.appendChild(div);
                    updateFileCount();
                };
                reader.readAsDataURL(file);
            });
        }
        
        // שליחת מייל
        async function sendEmail() {
            const email = document.getElementById('recipient_email').value;
            const subject = document.getElementById('email_subject').value;
            const body = document.getElementById('email_body').value;
            const attachTerms = document.getElementById('attach_terms').checked;
            
            if (!email) {
                alert('❌ יש להזין כתובת מייל');
                return;
            }
            
            // איסוף קבצים קיימים
            const existingFiles = [];
            document.querySelectorAll('.file-item[data-path]').forEach(item => {
                existingFiles.push(item.dataset.path);
            });
            
            // איסוף קבצים חדשים
            const newFiles = [];
            document.querySelectorAll('.file-item[data-new-file]').forEach(item => {
                const idx = parseInt(item.dataset.newFile);
                if (newFilesData[idx]) {
                    newFiles.push(newFilesData[idx]);
                }
            });
            
            if (!confirm('לשלוח את האישור ל-' + email + '?')) {
                return;
            }
            
            try {
                const response = await fetch('api/send_order_confirmation.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({
                        order_id: <?= $orderId ?>,
                        email: email,
                        subject: subject,
                        body: body,
                        existing_files: existingFiles,
                        new_files: newFiles,
                        attach_terms: attachTerms
                    })
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('✅ המייל נשלח בהצלחה!');
                    window.location.href = 'view_order_new.php?id=<?= $orderId ?>';
                } else {
                    alert('❌ שגיאה: ' + (result.error || 'לא ידוע'));
                }
            } catch (e) {
                alert('❌ שגיאה בשליחה: ' + e.message);
            }
        }
    </script>
</body>
</html>