<?php
// סקריפט התקנה ראשונית
// ========================================
// !!! מחק קובץ זה אחרי ההתקנה !!!
// ========================================

require_once 'includes/config.php';

$message = '';
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    try {
        $pdo = getDB();
        
        if ($action === 'create_tables') {
            // יצירת טבלאות
            $sql = "
            CREATE TABLE IF NOT EXISTS agents (
                id INT PRIMARY KEY AUTO_INCREMENT,
                username VARCHAR(50) UNIQUE NOT NULL,
                password VARCHAR(255) NOT NULL,
                full_name VARCHAR(100) NOT NULL,
                role ENUM('admin', 'agent') DEFAULT 'agent',
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

            CREATE TABLE IF NOT EXISTS orders (
                id INT PRIMARY KEY AUTO_INCREMENT,
                draft_token VARCHAR(64) UNIQUE NOT NULL,
                agent_id INT NOT NULL,
                order_date DATE,
                customer_phone VARCHAR(20) NOT NULL,
                customer_email VARCHAR(100),
                passengers JSON,
                destination VARCHAR(100) NOT NULL,
                departure_date DATE NOT NULL,
                return_date DATE NOT NULL,
                airline_outbound VARCHAR(100),
                booking_code_outbound VARCHAR(50),
                airline_return VARCHAR(100),
                booking_code_return VARCHAR(50),
                flight_supplier_paid ENUM('paid', 'unpaid') DEFAULT 'paid',
                hotel_name VARCHAR(100),
                hotel_checkin DATE,
                hotel_checkout DATE,
                room_type VARCHAR(100),
                hotel_confirmation VARCHAR(100),
                meal_basis ENUM('ללא ארוחות', 'לינה וארוחת בוקר', 'חצי פנסיון', 'פנסיון מלא', 'הכל כלול'),
                hotel_supplier_paid ENUM('paid', 'unpaid') DEFAULT 'paid',
                luggage_details TEXT,
                total_price DECIMAL(10,2) NOT NULL,
                profit DECIMAL(10,2),
                payments JSON,
                deal_builder VARCHAR(100),
                notes TEXT,
                status ENUM('draft', 'sent', 'paid', 'confirmed', 'cancelled') DEFAULT 'draft',
                payment_reference VARCHAR(100),
                paid_at TIMESTAMP NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                FOREIGN KEY (agent_id) REFERENCES agents(id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
            ";
            
            $pdo->exec($sql);
            $message = '✅ הטבלאות נוצרו בהצלחה!';
            $success = true;
            
        } elseif ($action === 'create_agent') {
            $username = $_POST['username'] ?? '';
            $password = $_POST['password'] ?? '';
            $fullname = $_POST['fullname'] ?? '';
            $role = $_POST['role'] ?? 'agent';
            
            if (empty($username) || empty($password) || empty($fullname)) {
                throw new Exception('כל השדות חובה');
            }
            
            $hashedPassword = password_hash($password, PASSWORD_BCRYPT, ['cost' => 10]);
            
            $stmt = $pdo->prepare("INSERT INTO agents (username, password, full_name, role) VALUES (?, ?, ?, ?)");
            $stmt->execute([$username, $hashedPassword, $fullname, $role]);
            
            $message = "✅ המשתמש '{$username}' נוצר בהצלחה!";
            $success = true;
        }
        
    } catch (Exception $e) {
        $message = '❌ שגיאה: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>התקנת מערכת CRM</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="container" style="margin-top:50px;">
        <div class="card">
            <h1 class="card-title">⚙️ התקנת מערכת CRM</h1>
            
            <div style="background:#fff3cd; padding:15px; border-radius:8px; margin-bottom:25px; color:#856404;">
                <strong>⚠️ חשוב:</strong> מחק קובץ זה (setup.php) מיד לאחר סיום ההתקנה!
            </div>
            
            <?php if ($message): ?>
                <div style="background:<?= $success ? '#d4edda' : '#f8d7da' ?>; color:<?= $success ? '#155724' : '#721c24' ?>; padding:15px; border-radius:8px; margin-bottom:25px;">
                    <?= $message ?>
                </div>
            <?php endif; ?>

            <!-- שלב 1: יצירת טבלאות -->
            <div class="form-section">
                <h2 class="section-title">שלב 1: יצירת טבלאות</h2>
                <p style="margin-bottom:15px; color:#666;">וודא שעדכנת את פרטי הדאטאבייס ב-includes/config.php</p>
                <form method="POST">
                    <input type="hidden" name="action" value="create_tables">
                    <button type="submit" class="btn btn-primary">צור טבלאות</button>
                </form>
            </div>

            <!-- שלב 2: יצירת משתמשים -->
            <div class="form-section" style="margin-top:30px;">
                <h2 class="section-title">שלב 2: יצירת משתמש</h2>
                <form method="POST">
                    <input type="hidden" name="action" value="create_agent">
                    <div class="form-row">
                        <div class="form-group">
                            <label>שם משתמש</label>
                            <input type="text" name="username" required placeholder="ok">
                        </div>
                        <div class="form-group">
                            <label>סיסמה</label>
                            <input type="password" name="password" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>שם מלא</label>
                            <input type="text" name="fullname" required placeholder="אוקי">
                        </div>
                        <div class="form-group">
                            <label>תפקיד</label>
                            <select name="role">
                                <option value="admin">אדמין</option>
                                <option value="agent">נציג</option>
                            </select>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">צור משתמש</button>
                </form>
            </div>

            <!-- שלב 3 -->
            <div class="form-section" style="margin-top:30px;">
                <h2 class="section-title">שלב 3: בדיקה</h2>
                <p style="color:#666;">אחרי שיצרת את המשתמשים:</p>
                <ol style="margin:15px 20px; color:#666;">
                    <li>לך ל-<a href="login.php">עמוד ההתחברות</a></li>
                    <li>התחבר עם המשתמש שיצרת</li>
                    <li>וודא שהכל עובד</li>
                    <li><strong style="color:#e94560;">מחק את קובץ setup.php!</strong></li>
                </ol>
            </div>
        </div>
    </div>
</body>
</html>
