<?php
// דוח חובות לספקים
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();

// פילטר לפי ספק
$selectedSupplier = $_GET['supplier'] ?? '';

// שליפת כל הספקים
$suppliers = [];
$stmt = $pdo->query("
    SELECT DISTINCT flight_supplier as supplier FROM orders WHERE flight_supplier IS NOT NULL AND flight_supplier != '' AND flight_supplier != 'ישיר' AND flight_supplier != 'DIRECT'
    UNION
    SELECT DISTINCT hotel_supplier as supplier FROM orders WHERE hotel_supplier IS NOT NULL AND hotel_supplier != '' AND hotel_supplier != 'ישיר מהמלון'
    UNION
    SELECT DISTINCT package_supplier as supplier FROM orders WHERE package_supplier IS NOT NULL AND package_supplier != ''
");
while ($row = $stmt->fetch()) {
    if ($row['supplier']) $suppliers[] = $row['supplier'];
}
$suppliers = array_unique($suppliers);
sort($suppliers);

// שליפת סיכום חובות לכל ספק
$debtsQuery = "
    SELECT 
        supplier,
        currency,
        SUM(cost) as total_debt,
        COUNT(*) as order_count
    FROM (
        SELECT flight_supplier as supplier, flight_supplier_currency as currency, flight_supplier_cost as cost
        FROM orders 
        WHERE flight_supplier_paid = 'unpaid' AND flight_supplier != '' AND flight_supplier != 'ישיר' AND flight_supplier != 'DIRECT' AND flight_supplier IS NOT NULL
        UNION ALL
        SELECT hotel_supplier as supplier, hotel_supplier_currency as currency, hotel_supplier_cost as cost
        FROM orders 
        WHERE hotel_supplier_paid = 'unpaid' AND hotel_supplier != '' AND hotel_supplier != 'ישיר מהמלון' AND hotel_supplier IS NOT NULL
        UNION ALL
        SELECT package_supplier as supplier, package_supplier_currency as currency, package_supplier_cost as cost
        FROM orders 
        WHERE package_supplier_paid = 'unpaid' AND package_supplier != '' AND package_supplier IS NOT NULL
        UNION ALL
        SELECT 
            CASE a.component 
                WHEN 'flight_outbound' THEN o.flight_supplier
                WHEN 'flight_return' THEN IFNULL(NULLIF(o.return_flight_supplier, ''), o.flight_supplier)
                WHEN 'hotel' THEN o.hotel_supplier
            END as supplier,
            a.currency,
            a.amount as cost
        FROM order_additions a
        JOIN orders o ON a.order_id = o.id
        WHERE a.is_paid = 0
    ) as debts
    WHERE supplier IS NOT NULL AND supplier != ''
    GROUP BY supplier, currency
    ORDER BY supplier, currency
";
$debts = $pdo->query($debtsQuery)->fetchAll();

// ארגון לפי ספק
$debtsBySupplier = [];
foreach ($debts as $debt) {
    if (!isset($debtsBySupplier[$debt['supplier']])) {
        $debtsBySupplier[$debt['supplier']] = [];
    }
    $debtsBySupplier[$debt['supplier']][] = $debt;
}

// שליפת הזמנות שטרם שולמו (לפירוט)
$ordersQuery = "
    SELECT 
        o.id,
        o.order_type,
        o.order_date,
        o.destination,
        o.departure_date,
        o.passengers,
        'flight' as type,
        o.flight_supplier as supplier,
        o.flight_supplier_booking as supplier_booking,
        o.flight_supplier_cost as cost,
        o.flight_supplier_currency as currency,
        o.airline_outbound as details
    FROM orders o
    WHERE o.flight_supplier_paid = 'unpaid' AND o.flight_supplier != '' AND o.flight_supplier != 'ישיר' AND flight_supplier != 'DIRECT' AND o.flight_supplier IS NOT NULL
    " . ($selectedSupplier ? "AND o.flight_supplier = :supplier1" : "") . "
    
    UNION ALL
    
    SELECT 
        o.id,
        o.order_type,
        o.order_date,
        o.destination,
        o.departure_date,
        o.passengers,
        'hotel' as type,
        o.hotel_supplier as supplier,
        o.hotel_supplier_booking as supplier_booking,
        o.hotel_supplier_cost as cost,
        o.hotel_supplier_currency as currency,
        o.hotel_name as details
    FROM orders o
    WHERE o.hotel_supplier_paid = 'unpaid' AND o.hotel_supplier != '' AND o.hotel_supplier != 'ישיר מהמלון' AND o.hotel_supplier IS NOT NULL
    " . ($selectedSupplier ? "AND o.hotel_supplier = :supplier2" : "") . "
    
    UNION ALL
    
    SELECT 
        o.id,
        o.order_type,
        o.order_date,
        o.destination,
        o.departure_date,
        o.passengers,
        'package' as type,
        o.package_supplier as supplier,
        o.package_supplier_booking as supplier_booking,
        o.package_supplier_cost as cost,
        o.package_supplier_currency as currency,
        CONCAT(o.airline_outbound, ' + ', o.hotel_name) as details
    FROM orders o
    WHERE o.package_supplier_paid = 'unpaid' AND o.package_supplier != '' AND o.package_supplier IS NOT NULL
    " . ($selectedSupplier ? "AND o.package_supplier = :supplier3" : "") . "
    
    UNION ALL
    
    SELECT 
        o.id,
        o.order_type,
        o.order_date,
        o.destination,
        o.departure_date,
        o.passengers,
        'addition' as type,
        CASE a.component 
            WHEN 'flight_outbound' THEN o.flight_supplier
            WHEN 'flight_return' THEN IFNULL(NULLIF(o.return_flight_supplier, ''), o.flight_supplier)
            WHEN 'hotel' THEN o.hotel_supplier
        END as supplier,
        CONCAT('תוספת: ', a.description) as supplier_booking,
        a.amount as cost,
        a.currency as currency,
        CASE a.component 
            WHEN 'flight_outbound' THEN 'תוספת טיסת הלוך'
            WHEN 'flight_return' THEN 'תוספת טיסת חזור'
            WHEN 'hotel' THEN 'תוספת מלון'
        END as details
    FROM order_additions a
    JOIN orders o ON a.order_id = o.id
    WHERE a.is_paid = 0
    " . ($selectedSupplier ? "AND (
        (a.component = 'flight_outbound' AND o.flight_supplier = :supplier4)
        OR (a.component = 'flight_return' AND IFNULL(NULLIF(o.return_flight_supplier, ''), o.flight_supplier) = :supplier5)
        OR (a.component = 'hotel' AND o.hotel_supplier = :supplier6)
    )" : "") . "
    
    ORDER BY supplier, departure_date
";

$stmt = $pdo->prepare($ordersQuery);
if ($selectedSupplier) {
    $stmt->execute([
        'supplier1' => $selectedSupplier, 
        'supplier2' => $selectedSupplier, 
        'supplier3' => $selectedSupplier,
        'supplier4' => $selectedSupplier,
        'supplier5' => $selectedSupplier,
        'supplier6' => $selectedSupplier
    ]);
} else {
    $stmt->execute();
}
$unpaidOrders = $stmt->fetchAll();

// סמלי מטבע
$currencySymbols = ['ILS' => '₪', 'USD' => '$', 'EUR' => '€'];
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>חובות לספקים - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .debt-cards {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .debt-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .debt-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        .debt-card.active {
            border: 3px solid #e94560;
        }
        .supplier-name {
            font-size: 1.3rem;
            font-weight: bold;
            color: #1e3c72;
            margin-bottom: 10px;
        }
        .debt-amounts {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }
        .debt-amount {
            font-size: 1.5rem;
            font-weight: bold;
            color: #e94560;
        }
        .order-count {
            color: #666;
            font-size: 0.9rem;
        }
        .all-paid {
            background: #d4edda;
            color: #155724;
            text-align: center;
            padding: 30px;
            border-radius: 10px;
        }
        .orders-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            table-layout: auto;
        }
        .orders-table th, .orders-table td {
            padding: 12px;
            text-align: right;
            border-bottom: 1px solid #ddd;
            vertical-align: middle;
        }
        .orders-table th {
            background: #f8f9fa;
            font-weight: 600;
            white-space: nowrap;
        }
        .orders-table td:last-child {
            white-space: nowrap;
            text-align: center;
        }
        .orders-table tr:hover {
            background: #f8f9fa;
        }
        .type-badge {
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 0.8rem;
        }
        .type-flight { background: #cce5ff; color: #004085; }
        .type-hotel { background: #d4edda; color: #155724; }
        .type-package { background: #fff3cd; color: #856404; }
        .btn-pay {
            background: #28a745;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 0.85rem;
            white-space: nowrap;
            display: inline-block;
        }
        .btn-pay:hover { background: #218838; }
        .filter-bar {
            background: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            gap: 15px;
            align-items: center;
        }
        .totals-summary {
            background: #fff3cd;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .totals-row {
            display: flex;
            gap: 30px;
            flex-wrap: wrap;
        }
        .total-item {
            font-size: 1.1rem;
        }
        .total-item strong {
            color: #e94560;
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo">💰 <?= SITE_NAME ?></div>
            <nav class="nav">
                <a href="orders_new.php">📋 הזמנות</a>
                <a href="complete_order.php">➕ הזמנה חדשה</a>
                <a href="supplier_debts.php" class="active">💰 חובות לספקים</a>
            </nav>
        </div>
    </header>

    <div class="container">
        <div class="card">
            <h1 class="card-title">💰 חובות לספקים</h1>
            
            <?php if (empty($debtsBySupplier)): ?>
                <div class="all-paid">
                    <h2>✅ אין חובות פתוחים!</h2>
                    <p>כל התשלומים לספקים בוצעו.</p>
                </div>
            <?php else: ?>
                <!-- כרטיסי ספקים -->
                <div class="debt-cards">
                    <?php foreach ($debtsBySupplier as $supplier => $currencies): ?>
                        <div class="debt-card <?= $selectedSupplier === $supplier ? 'active' : '' ?>" 
                             onclick="window.location='?supplier=<?= urlencode($supplier) ?>'">
                            <div class="supplier-name"><?= htmlspecialchars($supplier) ?></div>
                            <div class="debt-amounts">
                                <?php 
                                $totalOrders = 0;
                                foreach ($currencies as $curr): 
                                    $totalOrders += $curr['order_count'];
                                ?>
                                    <div class="debt-amount">
                                        <?= $currencySymbols[$curr['currency']] ?? $curr['currency'] ?>
                                        <?= number_format($curr['total_debt'], 2) ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="order-count"><?= $totalOrders ?> פריטים פתוחים</div>
                        </div>
                    <?php endforeach; ?>
                    
                    <?php if ($selectedSupplier): ?>
                        <div class="debt-card" onclick="window.location='supplier_debts.php'" style="background:#f8f9fa;">
                            <div class="supplier-name">🔄 הצג הכל</div>
                            <div class="order-count">לחץ לראות את כל הספקים</div>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- טבלת פירוט -->
                <?php if (!empty($unpaidOrders)): ?>
                    <h2 style="margin-top:30px;">
                        <?= $selectedSupplier ? "📋 פירוט - $selectedSupplier" : "📋 כל הפריטים הפתוחים" ?>
                    </h2>
                    
                    <div style="overflow-x: auto;">
                    <table class="orders-table">
                        <thead>
                            <tr>
                                <th>ספק</th>
                                <th>יעד</th>
                                <th>תאריך</th>
                                <th>מס' הזמנה</th>
                                <th>עלות</th>
                                <th>פעולה</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($unpaidOrders as $order): ?>
                                <tr>
                                    <td>
                                        <a href="view_order.php?id=<?= $order['id'] ?>" title="הזמנה #<?= $order['id'] ?>">
                                            <?= htmlspecialchars($order['supplier']) ?>
                                        </a>
                                        <br><small style="color:#888;">
                                            <?php 
                                            if ($order['type'] === 'flight') echo '✈️ טיסה';
                                            elseif ($order['type'] === 'hotel') echo '🏨 מלון';
                                            else echo '📦 חבילה';
                                            ?>
                                        </small>
                                    </td>
                                    <td><?= htmlspecialchars($order['destination']) ?></td>
                                    <td><?= date('d/m/y', strtotime($order['departure_date'])) ?></td>
                                    <td><strong><?= htmlspecialchars($order['supplier_booking']) ?></strong></td>
                                    <td>
                                        <strong style="color:#e94560;">
                                            <?= $currencySymbols[$order['currency']] ?? $order['currency'] ?>
                                            <?= number_format($order['cost'], 2) ?>
                                        </strong>
                                    </td>
                                    <td>
                                        <button class="btn-pay" onclick="markAsPaid(<?= $order['id'] ?>, '<?= $order['type'] ?>')">
                                            ✅ שולם
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
        function markAsPaid(orderId, type) {
            if (!confirm('האם לסמן כשולם?')) return;
            
            fetch('api/mark_supplier_paid.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({order_id: orderId, type: type})
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('שגיאה: ' + data.error);
                }
            });
        }
    </script>
</body>
</html>
