<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';
requireLogin();

$pdo = getDB();
$pdo->exec("SET NAMES utf8mb4");

$filterSupplier = $_GET['supplier'] ?? '';
$showPaid = isset($_GET['show_paid']);

// אוסף את כל החובות לספקים מ-orders + order_items
$supplierData = [];

// 1. טיסות
$stmt = $pdo->query("SELECT id, draft_token, customer_name, destination, departure_date,
    flight_supplier as supplier, flight_supplier_booking as booking_code, flight_supplier_cost as cost, flight_supplier_paid as paid
    FROM orders WHERE flight_supplier IS NOT NULL AND flight_supplier != ''");
foreach ($stmt as $row) {
    $supplier = $row['supplier'];
    if (!isset($supplierData[$supplier])) $supplierData[$supplier] = [];
    $supplierData[$supplier][] = [
        'order_id' => $row['id'],
        'customer' => $row['customer_name'],
        'destination' => $row['destination'],
        'date' => $row['departure_date'],
        'type' => 'טיסה',
        'booking_code' => $row['booking_code'],
        'cost' => $row['cost'],
        'paid' => $row['paid'] === 'paid',
        'field' => 'flight_supplier_paid'
    ];
}

// 2. מלונות
$stmt = $pdo->query("SELECT id, draft_token, customer_name, destination, departure_date,
    hotel_supplier as supplier, hotel_supplier_booking as booking_code, hotel_supplier_cost as cost, hotel_supplier_paid as paid
    FROM orders WHERE hotel_supplier IS NOT NULL AND hotel_supplier != ''");
foreach ($stmt as $row) {
    $supplier = $row['supplier'];
    if (!isset($supplierData[$supplier])) $supplierData[$supplier] = [];
    $supplierData[$supplier][] = [
        'order_id' => $row['id'],
        'customer' => $row['customer_name'],
        'destination' => $row['destination'],
        'date' => $row['departure_date'],
        'type' => 'מלון',
        'booking_code' => $row['booking_code'],
        'cost' => $row['cost'],
        'paid' => $row['paid'] === 'paid',
        'field' => 'hotel_supplier_paid'
    ];
}

// 3. חבילות
$stmt = $pdo->query("SELECT id, draft_token, customer_name, destination, departure_date,
    package_supplier as supplier, package_supplier_booking as booking_code, package_supplier_cost as cost, package_supplier_paid as paid
    FROM orders WHERE package_supplier IS NOT NULL AND package_supplier != ''");
foreach ($stmt as $row) {
    $supplier = $row['supplier'];
    if (!isset($supplierData[$supplier])) $supplierData[$supplier] = [];
    $supplierData[$supplier][] = [
        'order_id' => $row['id'],
        'customer' => $row['customer_name'],
        'destination' => $row['destination'],
        'date' => $row['departure_date'],
        'type' => 'חבילה',
        'booking_code' => $row['booking_code'],
        'cost' => $row['cost'],
        'paid' => $row['paid'] === 'paid',
        'field' => 'package_supplier_paid'
    ];
}

// 4. תוספות מ-order_items
$stmt = $pdo->query("SELECT oi.*, o.customer_name, o.destination, o.departure_date
    FROM order_items oi
    JOIN orders o ON oi.order_id = o.id
    WHERE oi.supplier IS NOT NULL AND oi.supplier != ''");
foreach ($stmt as $row) {
    $supplier = $row['supplier'];
    if (!isset($supplierData[$supplier])) $supplierData[$supplier] = [];
    $supplierData[$supplier][] = [
        'order_id' => $row['order_id'],
        'item_id' => $row['id'],
        'customer' => $row['customer_name'],
        'destination' => $row['destination'],
        'date' => $row['departure_date'],
        'type' => $row['description'] ?: $row['item_type'],
        'booking_code' => $row['supplier_booking_code'],
        'cost' => $row['supplier_cost'],
        'paid' => (bool)$row['supplier_paid'],
        'is_item' => true
    ];
}

// חישוב סיכומים
$supplierTotals = [];
foreach ($supplierData as $supplier => $items) {
    $total = 0;
    $unpaid = 0;
    foreach ($items as $item) {
        $total += $item['cost'];
        if (!$item['paid']) $unpaid += $item['cost'];
    }
    $supplierTotals[$supplier] = ['total' => $total, 'unpaid' => $unpaid, 'count' => count($items)];
}

// מיון לפי חוב פתוח
uasort($supplierTotals, fn($a, $b) => $b['unpaid'] <=> $a['unpaid']);

$totalUnpaid = array_sum(array_column($supplierTotals, 'unpaid'));

// פילטר
if ($filterSupplier) {
    $supplierData = [$filterSupplier => $supplierData[$filterSupplier] ?? []];
}
if (!$showPaid) {
    foreach ($supplierData as $supplier => &$items) {
        $items = array_filter($items, fn($i) => !$i['paid']);
    }
}
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>דוח ספקים - חופשה במבצע</title>
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { font-family: 'Segoe UI', Arial, sans-serif; background: #f0f2f5; min-height: 100vh; }
        
        .header { background: linear-gradient(135deg, #1e3c72, #2a5298); color: white; padding: 20px; }
        .header-content { max-width: 1400px; margin: 0 auto; display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px; }
        .header h1 { font-size: 1.5rem; }
        .header-actions a { color: white; text-decoration: none; background: rgba(255,255,255,0.2); padding: 10px 20px; border-radius: 8px; margin-right: 10px; }
        
        .container { max-width: 1400px; margin: 0 auto; padding: 20px; }
        
        .total-banner { background: linear-gradient(135deg, #dc3545, #c82333); color: white; padding: 30px; border-radius: 12px; text-align: center; margin-bottom: 25px; }
        .total-banner .amount { font-size: 2.5rem; font-weight: bold; }
        .total-banner .label { font-size: 1.1rem; opacity: 0.9; margin-top: 5px; }
        
        .filters { background: white; padding: 20px; border-radius: 12px; margin-bottom: 20px; display: flex; gap: 15px; align-items: center; flex-wrap: wrap; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .filters select { padding: 10px 15px; border: 1px solid #ddd; border-radius: 8px; font-size: 1rem; min-width: 200px; }
        .filters label { display: flex; align-items: center; gap: 8px; cursor: pointer; }
        
        .supplier-cards { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px; margin-bottom: 30px; }
        .supplier-card { background: white; border-radius: 12px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); cursor: pointer; transition: transform 0.2s; border: 3px solid transparent; }
        .supplier-card:hover { transform: translateY(-3px); }
        .supplier-card.selected { border-color: #1e3c72; }
        .supplier-card h3 { color: #1e3c72; margin-bottom: 15px; font-size: 1.1rem; }
        .supplier-card .unpaid { font-size: 1.5rem; font-weight: bold; color: #dc3545; }
        .supplier-card .total { color: #666; font-size: 0.9rem; margin-top: 5px; }
        
        .details { background: white; border-radius: 12px; padding: 25px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .details h2 { margin-bottom: 20px; color: #1e3c72; }
        
        .supplier-section { margin-bottom: 30px; }
        .supplier-section h3 { background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 15px; display: flex; justify-content: space-between; }
        .supplier-section h3 .debt { color: #dc3545; }
        
        table { width: 100%; border-collapse: collapse; }
        th { background: #f8f9fa; padding: 12px; text-align: right; font-weight: 600; border-bottom: 2px solid #eee; }
        td { padding: 12px; border-bottom: 1px solid #eee; }
        tr:hover { background: #f8f9fa; }
        
        .booking-code { font-family: monospace; background: #e3f2fd; padding: 3px 8px; border-radius: 4px; font-size: 0.9rem; }
        .type-badge { padding: 3px 10px; border-radius: 15px; font-size: 0.85rem; background: #e8f5e9; color: #2e7d32; }
        .paid-yes { background: #28a745; color: white; padding: 3px 10px; border-radius: 10px; font-size: 0.8rem; }
        .paid-no { background: #dc3545; color: white; padding: 3px 10px; border-radius: 10px; font-size: 0.8rem; }
        
        .mark-paid { background: #28a745; color: white; border: none; padding: 5px 12px; border-radius: 5px; cursor: pointer; font-size: 0.85rem; }
        .mark-paid:hover { background: #218838; }
        
        .order-link { color: #1e3c72; text-decoration: none; font-weight: 500; }
        .order-link:hover { text-decoration: underline; }
        
        .empty { text-align: center; padding: 40px; color: #666; }
        
        @media print {
            .header, .filters, .mark-paid, .supplier-cards { display: none; }
            .details { box-shadow: none; }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <h1>📊 דוח ספקים</h1>
            <div class="header-actions">
                <a href="#" onclick="window.print()">🖨️ הדפס</a>
                <a href="orders.php">← הזמנות</a>
                <a href="dashboard.php">🏠 ראשי</a>
            </div>
        </div>
    </div>
    
    <div class="container">
        <div class="total-banner">
            <div class="amount">₪<?= number_format($totalUnpaid) ?></div>
            <div class="label">סה"כ חוב פתוח לספקים</div>
        </div>
        
        <form class="filters" method="GET">
            <select name="supplier" onchange="this.form.submit()">
                <option value="">כל הספקים</option>
                <?php foreach ($supplierTotals as $name => $data): ?>
                <option value="<?= htmlspecialchars($name) ?>" <?= $filterSupplier === $name ? 'selected' : '' ?>>
                    <?= htmlspecialchars($name) ?> (₪<?= number_format($data['unpaid']) ?>)
                </option>
                <?php endforeach; ?>
            </select>
            <label>
                <input type="checkbox" name="show_paid" <?= $showPaid ? 'checked' : '' ?> onchange="this.form.submit()">
                הצג גם ששולמו
            </label>
        </form>
        
        <div class="supplier-cards">
            <?php foreach ($supplierTotals as $name => $data): ?>
            <div class="supplier-card <?= $filterSupplier === $name ? 'selected' : '' ?>" onclick="location.href='?supplier=<?= urlencode($name) ?><?= $showPaid ? '&show_paid=1' : '' ?>'">
                <h3><?= htmlspecialchars($name) ?></h3>
                <div class="unpaid">₪<?= number_format($data['unpaid']) ?></div>
                <div class="total"><?= $data['count'] ?> פריטים | סה"כ: ₪<?= number_format($data['total']) ?></div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="details">
            <h2>📋 פירוט</h2>
            
            <?php 
            $hasData = false;
            foreach ($supplierData as $supplier => $items): 
                if (empty($items)) continue;
                $hasData = true;
                $supplierUnpaid = array_sum(array_map(fn($i) => $i['paid'] ? 0 : $i['cost'], $items));
            ?>
            <div class="supplier-section">
                <h3>
                    <span><?= htmlspecialchars($supplier) ?></span>
                    <span class="debt">חוב: ₪<?= number_format($supplierUnpaid) ?></span>
                </h3>
                
                <table>
                    <thead>
                        <tr>
                            <th>הזמנה</th>
                            <th>לקוח</th>
                            <th>יעד</th>
                            <th>תאריך</th>
                            <th>סוג</th>
                            <th>קוד הזמנה ספק</th>
                            <th>עלות</th>
                            <th>סטטוס</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($items as $item): ?>
                        <tr>
                            <td><a href="order_view.php?id=<?= $item['order_id'] ?>" class="order-link">#<?= $item['order_id'] ?></a></td>
                            <td><?= htmlspecialchars($item['customer']) ?></td>
                            <td><?= htmlspecialchars($item['destination']) ?></td>
                            <td><?= $item['date'] ? date('d/m/Y', strtotime($item['date'])) : '-' ?></td>
                            <td><span class="type-badge"><?= htmlspecialchars($item['type']) ?></span></td>
                            <td><?= $item['booking_code'] ? '<span class="booking-code">' . htmlspecialchars($item['booking_code']) . '</span>' : '-' ?></td>
                            <td><strong>₪<?= number_format($item['cost']) ?></strong></td>
                            <td>
                                <?php if ($item['paid']): ?>
                                <span class="paid-yes">✓ שולם</span>
                                <?php else: ?>
                                <span class="paid-no">לא שולם</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if (!$item['paid']): ?>
                                <button class="mark-paid" onclick="markPaid(<?= $item['order_id'] ?>, '<?= $item['is_item'] ?? false ? 'item_' . $item['item_id'] : $item['field'] ?>')">סמן כשולם</button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endforeach; ?>
            
            <?php if (!$hasData): ?>
            <div class="empty">
                <p>אין נתונים להצגה</p>
            </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
    function markPaid(orderId, field) {
        if (!confirm('לסמן כשולם לספק?')) return;
        
        fetch('api/mark_supplier_paid.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({order_id: orderId, field: field})
        })
        .then(r => r.json())
        .then(data => {
            if (data.success) location.reload();
            else alert('שגיאה: ' + data.error);
        });
    }
    </script>
</body>
</html>
