<?php
/**
 * Invoice4U SOAP API Test
 * בדיקת חיבור והפקת קבלה
 */

require_once __DIR__ . '/includes/invoice4u.php';

$action = $_GET['action'] ?? $_POST['action'] ?? '';
$result = null;

// יצירת אובייקט Invoice4U
$invoice4u = new Invoice4U();

if ($action === 'test_connection') {
    $result = $invoice4u->testConnection();
}

if ($action === 'create_receipt') {
    $receiptData = [
        'customer_name' => $_POST['customer_name'] ?? 'לקוח טסט',
        'customer_email' => $_POST['customer_email'] ?? '',
        'amount' => floatval($_POST['amount'] ?? 1.00),
        'description' => $_POST['description'] ?? 'בדיקת מערכת',
        'payment_type' => $_POST['payment_type'] ?? 'credit_card',
        'last_4_digits' => $_POST['last_4_digits'] ?? '0000',
        'approval_number' => $_POST['approval_number'] ?? '12345',
        'installments' => intval($_POST['installments'] ?? 1),
        'card_brand' => $_POST['card_brand'] ?? 'Visa'
    ];
    
    $result = $invoice4u->createReceipt($receiptData);
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="he">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>בדיקת Invoice4U SOAP API</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body { padding: 20px; background: #f5f5f5; }
        .card { margin-bottom: 20px; }
        pre { background: #1e1e1e; color: #d4d4d4; padding: 15px; border-radius: 8px; direction: ltr; text-align: left; overflow-x: auto; }
        .success { color: #28a745; }
        .error { color: #dc3545; }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="mb-4">🧾 בדיקת Invoice4U SOAP API</h1>
        
        <!-- תוצאה -->
        <?php if ($result): ?>
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <?php if (!empty($result['success'])): ?>
                        <span class="success">✅ הצלחה</span>
                    <?php else: ?>
                        <span class="error">❌ שגיאה</span>
                    <?php endif; ?>
                </h5>
            </div>
            <div class="card-body">
                <?php if (!empty($result['success']) && !empty($result['pdf_link'])): ?>
                <div class="alert alert-success">
                    <h4>🧾 קבלה מספר: <?= htmlspecialchars($result['document_number']) ?></h4>
                    <p>לקוח: <?= htmlspecialchars($result['client_name'] ?? '') ?></p>
                    <p>סכום: <?= number_format($result['total'], 2) ?> ₪</p>
                    <a href="<?= htmlspecialchars($result['pdf_link']) ?>" target="_blank" class="btn btn-primary btn-lg">
                        📄 צפייה בקבלה (PDF)
                    </a>
                </div>
                <?php endif; ?>
                <pre><?= json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) ?></pre>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- בדיקת חיבור -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">🔗 בדיקת חיבור</h5>
            </div>
            <div class="card-body">
                <p>בודק את תקינות ה-Token וחיבור ל-SOAP API</p>
                <form method="POST">
                    <input type="hidden" name="action" value="test_connection">
                    <button type="submit" class="btn btn-primary">בדיקת חיבור</button>
                </form>
            </div>
        </div>
        
        <!-- הפקת קבלה -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">🧾 הפקת קבלה לבדיקה</h5>
            </div>
            <div class="card-body">
                <form method="POST">
                    <input type="hidden" name="action" value="create_receipt">
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">שם לקוח</label>
                            <input type="text" name="customer_name" class="form-control" value="לקוח טסט">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">אימייל</label>
                            <input type="email" name="customer_email" class="form-control" placeholder="לא חובה">
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">סכום</label>
                            <input type="number" name="amount" class="form-control" value="1.00" step="0.01">
                        </div>
                        <div class="col-md-8 mb-3">
                            <label class="form-label">תיאור</label>
                            <input type="text" name="description" class="form-control" value="בדיקת מערכת">
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label class="form-label">סוג תשלום</label>
                            <select name="payment_type" class="form-select">
                                <option value="credit_card">כרטיס אשראי</option>
                                <option value="cash">מזומן</option>
                                <option value="check">צ'ק</option>
                                <option value="transfer">העברה בנקאית</option>
                                <option value="bit">ביט</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">4 ספרות אחרונות</label>
                            <input type="text" name="last_4_digits" class="form-control" value="0000" maxlength="4">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">מספר אישור</label>
                            <input type="text" name="approval_number" class="form-control" value="12345">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">תשלומים</label>
                            <input type="number" name="installments" class="form-control" value="1" min="1" max="36">
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">סוג כרטיס</label>
                        <select name="card_brand" class="form-select" style="width: 200px;">
                            <option value="Visa">Visa</option>
                            <option value="MasterCard">MasterCard</option>
                            <option value="Isracard">Isracard</option>
                            <option value="Amex">Amex</option>
                            <option value="Diners">Diners</option>
                        </select>
                    </div>
                    
                    <button type="submit" class="btn btn-success btn-lg">הפק קבלה</button>
                </form>
            </div>
        </div>
        
        <!-- מידע טכני -->
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">ℹ️ מידע טכני</h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <tr>
                        <th>WSDL URL:</th>
                        <td><code>https://api.invoice4u.co.il/Services/ApiService.svc?singleWsdl</code></td>
                    </tr>
                    <tr>
                        <th>Token:</th>
                        <td><code>835ed34c-30bb-499b-8dd7-1460dba1343b</code></td>
                    </tr>
                    <tr>
                        <th>PHP SOAP Extension:</th>
                        <td>
                            <?php if (extension_loaded('soap')): ?>
                                <span class="text-success">✅ מותקן</span>
                            <?php else: ?>
                                <span class="text-danger">❌ לא מותקן</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th>סוגי מסמכים:</th>
                        <td>
                            1=Invoice, 2=Receipt, 3=InvoiceReceipt, 4=Credit, 5=Proforma, 6=Order, 7=Quote
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <!-- לוג אחרון -->
        <?php
        $logFile = __DIR__ . '/logs/invoice4u_' . date('Y-m-d') . '.log';
        if (file_exists($logFile)):
            $logContent = file_get_contents($logFile);
            $logLines = array_slice(explode("\n", $logContent), -20);
        ?>
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">📋 לוג אחרון</h5>
            </div>
            <div class="card-body">
                <pre style="max-height: 300px; overflow-y: auto;"><?= htmlspecialchars(implode("\n", $logLines)) ?></pre>
            </div>
        </div>
        <?php endif; ?>
        
    </div>
</body>
</html>
