<?php
// בדיקת API של update_order
require_once 'includes/auth.php';
requireLogin();

echo "<h2>בדיקת update_order API</h2>";
echo "<pre>";

// בדיקה שהקובץ קיים
$apiFile = __DIR__ . '/api/update_order.php';
if (file_exists($apiFile)) {
    echo "✅ הקובץ api/update_order.php קיים\n";
    echo "📅 תאריך שינוי: " . date('Y-m-d H:i:s', filemtime($apiFile)) . "\n";
    echo "📏 גודל: " . filesize($apiFile) . " bytes\n\n";
    
    // הצג תחילת הקובץ
    echo "--- תחילת הקובץ ---\n";
    $content = file_get_contents($apiFile);
    echo htmlspecialchars(substr($content, 0, 500));
    echo "\n--- סוף תצוגה ---\n";
} else {
    echo "❌ הקובץ api/update_order.php לא קיים!\n";
}

echo "\n\n--- לוגים אחרונים ---\n";
$logFile = __DIR__ . '/logs/update_order_' . date('Y-m-d') . '.log';
if (file_exists($logFile)) {
    echo file_get_contents($logFile);
} else {
    echo "אין לוג להיום\n";
}

echo "</pre>";
?>
