<?php
// Voucher Lite - עמוד פתיחה + צילומי מסך
require_once 'includes/config.php';

$token = $_GET['token'] ?? null;

if (!$token) {
    die('Token not found');
}

try {
    $pdo = getDB();
    $stmt = $pdo->prepare("SELECT o.*, a.full_name as agent_name FROM orders o JOIN agents a ON o.agent_id = a.id WHERE o.draft_token = ?");
    $stmt->execute([$token]);
    $order = $stmt->fetch();
} catch (Exception $e) {
    die('Database error: ' . $e->getMessage());
}

if (!$order) {
    die('Order not found');
}

$passengers = json_decode($order['passengers'] ?? '[]', true) ?: [];

// חיפוש קבצי וואצ'ר
$voucherFiles = [];
$orderDate = $order['order_date'] ?? $order['created_at'] ?? date('Y-m-d');
$uploadDirs = [
    'uploads/vouchers/' . date('Y/m/', strtotime($orderDate)),
    'uploads/vouchers/' . date('Y/m/'),
    'uploads/vouchers/'
];

foreach ($uploadDirs as $dir) {
    $jsonFile = $dir . 'order_' . $order['id'] . '_files.json';
    if (file_exists($jsonFile)) {
        $content = file_get_contents($jsonFile);
        $data = json_decode($content, true);
        if ($data && !empty($data['files'])) {
            $voucherFiles = $data['files'];
            break;
        }
    }
}

// תרגום יעד לעברית
function translateDestination($dest) {
    $translations = [
        'budapest' => 'בודפשט', 'prague' => 'פראג', 'rome' => 'רומא', 'paris' => 'פריז',
        'barcelona' => 'ברצלונה', 'amsterdam' => 'אמסטרדם', 'london' => 'לונדון', 'vienna' => 'וינה',
        'berlin' => 'ברלין', 'athens' => 'אתונה', 'lisbon' => 'ליסבון', 'madrid' => 'מדריד',
        'milan' => 'מילאנו', 'venice' => 'ונציה', 'florence' => 'פירנצה', 'krakow' => 'קרקוב',
        'warsaw' => 'ורשה', 'dublin' => 'דבלין', 'brussels' => 'בריסל', 'munich' => 'מינכן',
        'salzburg' => 'זלצבורג', 'rhodes' => 'רודוס', 'crete' => 'כרתים', 'cyprus' => 'קפריסין',
        'larnaca' => 'לרנקה', 'paphos' => 'פאפוס', 'sofia' => 'סופיה', 'bucharest' => 'בוקרשט',
        'istanbul' => 'איסטנבול', 'antalya' => 'אנטליה', 'tbilisi' => 'טביליסי', 'batumi' => 'באטומי'
    ];
    
    $lower = strtolower($dest);
    foreach ($translations as $eng => $heb) {
        if (strpos($lower, $eng) !== false) {
            return $heb;
        }
    }
    return $dest;
}

$hebrewDest = translateDestination($order['destination']);
?>
<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>אישור הזמנה - <?= htmlspecialchars($hebrewDest) ?></title>
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Arial, sans-serif;
            background: #f5f5f5;
            color: #333;
            line-height: 1.6;
        }
        
        .container {
            max-width: 800px;
            margin: 20px auto;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        /* עמוד פתיחה */
        .cover-page {
            padding: 40px;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            page-break-after: always;
        }
        
        .header {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .logo {
            font-size: 2.5rem;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 10px;
        }
        
        .logo-subtitle {
            color: #888;
            font-size: 1rem;
        }
        
        .title {
            text-align: center;
            margin: 40px 0;
        }
        
        .title h1 {
            font-size: 2rem;
            color: #333;
            margin-bottom: 10px;
        }
        
        .title .destination {
            font-size: 2.5rem;
            color: #667eea;
            font-weight: bold;
        }
        
        .info-box {
            background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
            border-radius: 15px;
            padding: 30px;
            margin: 30px 0;
        }
        
        .info-row {
            display: flex;
            align-items: center;
            padding: 12px 0;
            border-bottom: 1px solid rgba(102, 126, 234, 0.1);
        }
        
        .info-row:last-child {
            border-bottom: none;
        }
        
        .info-icon {
            font-size: 1.5rem;
            width: 50px;
            text-align: center;
        }
        
        .info-label {
            flex: 1;
            font-weight: 600;
            color: #555;
        }
        
        .info-value {
            flex: 2;
            font-size: 1.1rem;
            color: #333;
        }
        
        .emergency {
            background: #fff3cd;
            border: 2px solid #ffc107;
            border-radius: 10px;
            padding: 20px;
            margin-top: auto;
            text-align: center;
        }
        
        .emergency-title {
            font-weight: bold;
            color: #856404;
            margin-bottom: 5px;
        }
        
        .emergency-phone {
            font-size: 1.5rem;
            color: #856404;
            font-weight: bold;
            direction: ltr;
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            color: #888;
            font-size: 0.9rem;
        }
        
        /* עמודי תמונות */
        .attachment-page {
            page-break-before: always;
            padding: 20px;
        }
        
        .attachment-title {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 1.2rem;
        }
        
        .attachment-image {
            width: 100%;
            max-height: 85vh;
            object-fit: contain;
            border: 1px solid #ddd;
            border-radius: 10px;
        }
        
        .no-attachments {
            text-align: center;
            padding: 60px;
            color: #888;
        }
        
        .no-attachments-icon {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        /* כפתורי פעולה */
        .actions {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 10px;
            background: white;
            padding: 15px 25px;
            border-radius: 50px;
            box-shadow: 0 5px 30px rgba(0,0,0,0.2);
            z-index: 1000;
        }
        
        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: 25px;
            font-size: 1rem;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        
        .btn-secondary {
            background: #f5f5f5;
            color: #333;
        }
        
        @media print {
            .actions {
                display: none;
            }
            
            body {
                background: white;
            }
            
            .container {
                box-shadow: none;
                margin: 0;
            }
        }
    </style>
</head>
<body>
    <div class="container" id="voucher-content">
        <!-- עמוד פתיחה -->
        <div class="cover-page">
            <div class="header">
                <div class="logo">✈️ חופשה במבצע</div>
                <div class="logo-subtitle">אישור הזמנה רשמי</div>
            </div>
            
            <div class="title">
                <h1>אישור הזמנה</h1>
                <div class="destination"><?= htmlspecialchars($hebrewDest) ?></div>
            </div>
            
            <div class="info-box">
                <div class="info-row">
                    <span class="info-icon">👥</span>
                    <span class="info-label">נוסעים:</span>
                    <span class="info-value"><?= htmlspecialchars(implode(', ', $passengers)) ?></span>
                </div>
                
                <div class="info-row">
                    <span class="info-icon">📅</span>
                    <span class="info-label">תאריכים:</span>
                    <span class="info-value">
                        <?= formatHebrewDate($order['departure_date']) ?> 
                        עד 
                        <?= formatHebrewDate($order['return_date']) ?>
                    </span>
                </div>
                
                <?php if ($order['airline_outbound']): ?>
                <div class="info-row">
                    <span class="info-icon">✈️</span>
                    <span class="info-label">חברת תעופה:</span>
                    <span class="info-value">
                        <?= htmlspecialchars($order['airline_outbound']) ?>
                        <?php if ($order['airline_return'] && $order['airline_return'] !== $order['airline_outbound']): ?>
                            (הלוך) / <?= htmlspecialchars($order['airline_return']) ?> (חזור)
                        <?php endif; ?>
                    </span>
                </div>
                <?php endif; ?>
                
                <?php if ($order['booking_code_outbound']): ?>
                <div class="info-row">
                    <span class="info-icon">🔖</span>
                    <span class="info-label">קוד הזמנת טיסה:</span>
                    <span class="info-value" style="direction:ltr; text-align:right;">
                        <?= htmlspecialchars($order['booking_code_outbound']) ?>
                        <?php if ($order['booking_code_return'] && $order['booking_code_return'] !== $order['booking_code_outbound']): ?>
                            / <?= htmlspecialchars($order['booking_code_return']) ?>
                        <?php endif; ?>
                    </span>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($order['luggage_details'])): ?>
                <div class="info-row">
                    <span class="info-icon">🧳</span>
                    <span class="info-label">כבודה:</span>
                    <span class="info-value"><?= nl2br(htmlspecialchars($order['luggage_details'])) ?></span>
                </div>
                <?php endif; ?>
            </div>
            
            <div class="emergency">
                <div class="emergency-title">📞 למקרי חירום בחו"ל</div>
                <div class="emergency-phone">050-6101031</div>
            </div>
            
            <div class="footer">
                <p>להלן מצורפים אישורי ההזמנה מהספקים השונים</p>
                <p style="margin-top:10px;">🌴 מאחלים לכם חופשה נעימה! 🌴</p>
            </div>
        </div>
        
        <!-- עמודי צילומי מסך -->
        <?php if (!empty($voucherFiles)): ?>
            <?php foreach ($voucherFiles as $file): ?>
                <?php 
                // תיקון נתיב - הסר ../ אם קיים
                $filePath = $file['path'];
                if (strpos($filePath, '../') === 0) {
                    $filePath = substr($filePath, 3);
                }
                ?>
                <?php if (file_exists($filePath)): ?>
                    <div class="attachment-page">
                        <div class="attachment-title">
                            📎 <?= htmlspecialchars($file['label']) ?>
                        </div>
                        <?php 
                        $ext = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
                        if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])): 
                        ?>
                            <img src="<?= $filePath ?>" class="attachment-image" alt="<?= htmlspecialchars($file['label']) ?>">
                        <?php elseif ($ext === 'pdf'): ?>
                            <embed src="<?= $filePath ?>" type="application/pdf" width="100%" height="800px">
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="attachment-page">
                <div class="no-attachments">
                    <div class="no-attachments-icon">📄</div>
                    <h2>אין צילומי מסך מצורפים</h2>
                    <p>לא הועלו אישורי הזמנה לוואצ'ר זה</p>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- כפתורי פעולה -->
    <div class="actions">
        <button class="btn btn-secondary" onclick="window.history.back()">← חזור</button>
        <button class="btn btn-primary" onclick="generatePDF()">📥 הורד PDF</button>
    </div>
    
    <!-- ספריית html2pdf -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    <script>
        function generatePDF() {
            const element = document.getElementById('voucher-content');
            const actions = document.querySelector('.actions');
            
            // הסתר כפתורים
            actions.style.display = 'none';
            
            const opt = {
                margin: 10,
                filename: 'voucher_<?= $order['id'] ?>_<?= date('Y-m-d') ?>.pdf',
                image: { type: 'jpeg', quality: 0.98 },
                html2canvas: { scale: 2, useCORS: true },
                jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' },
                pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }
            };
            
            html2pdf().set(opt).from(element).save().then(() => {
                // החזר כפתורים
                actions.style.display = 'flex';
            });
        }
    </script>
</body>
</html>